/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    private static final int ONE_HUNDRED_KB = 102400;
    private static final int FOUR_KB = 4096;

    private Streams() {
    }

    public static void close(Closeable ... streams) {
        for (Closeable stream : streams) {
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void transfer(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is) throws IOException {
        byte[] byArray;
        try {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[102400];
            while ((read = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.close(is);
            throw throwable;
        }
        Streams.close(is);
        return byArray;
    }
}

