/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;

public class Converter {
    public static String toString(Object value, String upnpType) throws Exception {
        if (value == null || upnpType == null) {
            throw new NullPointerException("Must be specified a valid value and upnpType");
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return value.toString();
            }
            if (value instanceof Float) {
                return value.toString();
            }
            if (value instanceof Long) {
                if (upnpType.equals("time")) {
                    long l = (Long)value;
                    if (l < 0L) {
                        throw new IllegalArgumentException(l + "Must be greater than 0");
                    }
                    Calendar c = Calendar.getInstance();
                    c.set(11, (int)(l / 3600000L));
                    int x = (int)(l % 3600000L);
                    c.set(12, x / 60000);
                    c.set(13, x % 60000 / 1000);
                    SimpleDateFormat sdt = new SimpleDateFormat("HH:mm:ss");
                    return sdt.format(c.getTime());
                }
                if (upnpType.equals("time.tz")) {
                    long l = (Long)value;
                    if (l < 0L) {
                        throw new IllegalArgumentException(l + "Must be greater than 0");
                    }
                    Calendar c = Calendar.getInstance();
                    c.set(11, (int)(l / 3600000L));
                    int x = (int)(l % 3600000L);
                    c.set(12, x / 60000);
                    c.set(13, x % 60000 / 1000);
                    SimpleDateFormat sdt = new SimpleDateFormat("HH:mm:ssZ");
                    return sdt.format(c.getTime());
                }
                return value.toString();
            }
            if (value instanceof Double) {
                if (upnpType.equals("fixed.14.4")) {
                    return Long.toString(((Double)value).longValue()) + "." + Integer.toString((int)((Double)value * 10000.0 % 10000.0));
                }
                return value.toString();
            }
        } else if (value instanceof Date) {
            if (upnpType.equals("dateTime")) {
                SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return sdt.format(value);
            }
            if (upnpType.equals("dateTime.tz")) {
                SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                return sdt.format(value);
            }
            if (upnpType.equals("date")) {
                SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
                return sdt.format(value);
            }
        } else {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            if (value instanceof Character) {
                return value.toString();
            }
            if (value instanceof String) {
                return value.toString();
            }
            if (value instanceof byte[]) {
                if (upnpType.equals("bin.hex")) {
                    return HexBin.encode((byte[])value);
                }
                if (upnpType.equals("bin.base64")) {
                    return Base64.encode((byte[])value);
                }
            }
        }
        throw new IllegalArgumentException("Invalid Binding");
    }

    public static Object parseString(String value, String upnpType) throws Exception {
        if (value == null && upnpType.equals("string")) {
            value = "";
        }
        if (value == null || upnpType == null) {
            throw new NullPointerException("Must be specified a valid value and upnpType");
        }
        if (upnpType.equals("ui1") || upnpType.equals("ui2") || upnpType.equals("i1") || upnpType.equals("i2") || upnpType.equals("i4") || upnpType.equals("int")) {
            return new Integer(value);
        }
        if (upnpType.equals("ui4")) {
            return new Long(value);
        }
        if (upnpType.equals("time")) {
            String[] timeFormats = new String[]{"HH:mm:ss"};
            Date d = Converter.getDateValue(value, timeFormats, timeFormats);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            return new Long(c.get(11) * 3600000 + c.get(12) * 60000 + c.get(13) * 1000);
        }
        if (upnpType.equals("time.tz")) {
            String[] timeFormats = new String[]{"HH:mm:ssZ", "HH:mm:ss"};
            Date d = Converter.getDateValue(value, timeFormats, timeFormats);
            TimeZone tz = TimeZone.getDefault();
            Calendar c = Calendar.getInstance(tz);
            c.setTime(d);
            if (timeFormats[0].equals("HH:mm:ssZ") && tz.inDaylightTime(d)) {
                c.add(14, 3600000);
            }
            return new Long(c.get(11) * 3600000 + c.get(12) * 60000 + c.get(13) * 1000);
        }
        if (upnpType.equals("r4") || upnpType.equals("float")) {
            return new Float(value);
        }
        if (upnpType.equals("r8") || upnpType.equals("number") || upnpType.equals("fixed.14.4")) {
            return new Double(value);
        }
        if (upnpType.equals("char")) {
            return new Character(value.charAt(0));
        }
        if (upnpType.equals("string") || upnpType.equals("uri") || upnpType.equals("uuid")) {
            return value;
        }
        if (upnpType.equals("date")) {
            String[] timeFormats = new String[]{"yyyy-MM-dd"};
            Date d = Converter.getDateValue(value, timeFormats, timeFormats);
            return d;
        }
        if (upnpType.equals("dateTime")) {
            String[] timeFormats = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss"};
            Date d = Converter.getDateValue(value, timeFormats, timeFormats);
            return d;
        }
        if (upnpType.equals("dateTime.tz")) {
            String[] timeFormats = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ"};
            Date d = Converter.getDateValue(value, timeFormats, timeFormats);
            return d;
        }
        if (upnpType.equals("boolean")) {
            if (value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (upnpType.equals("bin.base64")) {
            return Base64.decode(value);
        }
        if (upnpType.equals("bin.hex")) {
            return HexBin.decode(value);
        }
        throw new IllegalArgumentException("Invalid Binding");
    }

    private static String normalizeTimeZone(String value) {
        if (value.endsWith("Z")) {
            value = value.substring(0, value.length() - 1) + "+0000";
        } else if (value.length() > 7 && value.charAt(value.length() - 3) == ':' && (value.charAt(value.length() - 6) == '-' || value.charAt(value.length() - 6) == '+')) {
            value = value.substring(0, value.length() - 3) + value.substring(value.length() - 2);
        }
        return value;
    }

    private static Date getDateValue(String value, String[] timeFormats, String[] choosedIndex) throws ParseException {
        ParsePosition position = null;
        value = Converter.normalizeTimeZone(value);
        for (int i = 0; i < timeFormats.length; ++i) {
            SimpleDateFormat sdt = new SimpleDateFormat(timeFormats[i]);
            position = new ParsePosition(0);
            Date d = sdt.parse(value, position);
            if (d == null || position.getIndex() < value.length()) continue;
            choosedIndex[0] = timeFormats[i];
            return d;
        }
        throw new ParseException("Error parsing " + value, position.getIndex());
    }
}

