/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.ant.types;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flex.compiler.ant.FlexTask;
import org.apache.flex.compiler.ant.config.ConfigBoolean;
import org.apache.flex.compiler.ant.config.ConfigString;
import org.apache.flex.compiler.ant.config.ConfigVariable;
import org.apache.flex.compiler.ant.config.IOptionSource;
import org.apache.flex.compiler.ant.config.NestedAttributeElement;
import org.apache.flex.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.types.Commandline;

public final class Fonts
implements IOptionSource,
DynamicConfigurator {
    private static final OptionSpec LANGUAGE_RANGE = new OptionSpec("compiler.fonts.languages.language-range");
    private static final OptionSpec MANAGERS = new OptionSpec("compiler.fonts.managers");
    private final ConfigVariable[] attribs = new ConfigVariable[]{new ConfigBoolean(new OptionSpec("compiler.fonts.flash-type")), new ConfigBoolean(new OptionSpec("compiler.fonts.advanced-anti-aliasing")), new ConfigString(new OptionSpec("compiler.fonts.local-fonts-snapshot")), new ConfigString(new OptionSpec("compiler.fonts.max-cached-fonts")), new ConfigString(new OptionSpec("compiler.fonts.max-glyphs-per-face"))};
    private final ArrayList<NestedAttributeElement> nestedAttribs = new ArrayList();
    private final FlexTask task;

    public Fonts() {
        this(null);
    }

    public Fonts(FlexTask task) {
        this.task = task;
    }

    public void setDynamicAttribute(String name, String value) {
        ConfigVariable var = null;
        for (int i = 0; i < this.attribs.length && var == null; ++i) {
            if (!this.attribs[i].matches(name)) continue;
            var = this.attribs[i];
        }
        if (var == null) {
            throw new BuildException("The <font> type doesn't support the \"" + name + "\" attribute.");
        }
        var.set(value);
    }

    public Object createDynamicElement(String name) {
        if (LANGUAGE_RANGE.matches(name)) {
            NestedAttributeElement e = new NestedAttributeElement(new String[]{"lang", "range"}, LANGUAGE_RANGE, this.task);
            this.nestedAttribs.add(e);
            return e;
        }
        throw new BuildException("Invalid element: " + name);
    }

    public NestedAttributeElement createManager() {
        NestedAttributeElement e = new NestedAttributeElement("class", MANAGERS, this.task);
        this.nestedAttribs.add(e);
        return e;
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        for (int i = 0; i < this.attribs.length; ++i) {
            this.attribs[i].addToCommandline(cmdline);
        }
        Iterator<NestedAttributeElement> it = this.nestedAttribs.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(cmdline);
        }
    }
}

