/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.common;

import org.apache.flex.compiler.common.PrefixMap;
import org.apache.flex.compiler.common.XMLName;
import org.apache.flex.compiler.internal.mxml.MXMLData;

public class PrefixedXMLName
extends XMLName {
    private String prefix;
    private String prefixedName;

    public PrefixedXMLName(String rawName, MXMLData mxmlData) {
        this.name = this.splitName(rawName);
        assert (this.name != null);
        this.xmlNamespace = this.resolvePrefix(this.prefix, mxmlData);
        if (this.xmlNamespace == null) {
            this.xmlNamespace = "";
        }
    }

    public PrefixedXMLName(String rawName, PrefixMap prefixMap) {
        this.name = this.splitName(rawName);
        assert (this.name != null);
        this.xmlNamespace = prefixMap.getNamespaceForPrefix(this.prefix);
        if (this.xmlNamespace == null) {
            this.xmlNamespace = "";
        }
    }

    public PrefixedXMLName(String rawName, String uri) {
        this.name = this.splitName(rawName);
        this.xmlNamespace = uri;
    }

    public PrefixedXMLName(String xmlNamespace, String name, String rawName) {
        this.splitName(rawName);
        this.name = name;
        assert (name != null);
        this.xmlNamespace = xmlNamespace == null ? "" : xmlNamespace;
    }

    private String splitName(String rawName) {
        String name;
        if (rawName == null) {
            this.prefix = "";
            return "";
        }
        int colonIndex = rawName.indexOf(":");
        if (colonIndex > -1) {
            this.prefix = rawName.substring(0, colonIndex);
            name = rawName.substring(colonIndex + 1);
        } else {
            this.prefix = "";
            name = rawName;
        }
        return name;
    }

    protected String resolvePrefix(String prefix, MXMLData mxmlData) {
        return this.resolvePrefix(prefix, mxmlData.getRootTagPrefixMap());
    }

    protected String resolvePrefix(String prefix, PrefixMap prefixMap) {
        if (prefixMap.containsPrefix(prefix)) {
            return prefixMap.getNamespaceForPrefix(prefix);
        }
        return "";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrefixedName() {
        if (this.prefixedName != null) {
            return this.prefixedName;
        }
        this.prefixedName = this.prefix != null && !this.prefix.equals("") ? (this.prefix + ":" + this.getName()).intern() : this.getName();
        return this.prefixedName;
    }
}

