/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;

public class QNameNormalization {
    public static String normalize(String name) {
        return QNameNormalization.normalize(name, ".");
    }

    public static String normalize(String name, String separator) {
        if (name == null) {
            return "";
        }
        return name.replaceAll("[\\.:\\\\/\\s]", separator);
    }

    public static Collection<String> normalize(Collection<String> names) {
        if (names == null) {
            return Collections.emptySet();
        }
        return Collections2.transform(names, (Function)new Function<String, String>(){

            public String apply(String name) {
                return QNameNormalization.normalize(name);
            }
        });
    }
}

