/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.css.ICSSMediaQueryCondition;
import org.apache.flex.compiler.css.ICSSProperty;
import org.apache.flex.compiler.css.ICSSRule;
import org.apache.flex.compiler.css.ICSSSelector;
import org.apache.flex.compiler.internal.css.CSSMediaQueryCondition;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSNodeBase;
import org.apache.flex.compiler.internal.css.CSSProperty;
import org.apache.flex.compiler.internal.css.CSSSelector;
import org.apache.flex.compiler.internal.css.CSSTypedNode;

public class CSSRule
extends CSSNodeBase
implements ICSSRule {
    private final ImmutableList<ICSSMediaQueryCondition> mediaQueryList;
    private final ImmutableList<ICSSSelector> selectorGroup;
    private final ImmutableList<ICSSProperty> propertyList;

    public CSSRule(List<CSSMediaQueryCondition> mediaQueries, List<CSSSelector> selectorGroup, List<CSSProperty> properties, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.RULE);
        assert (selectorGroup != null) : "Subject can't be null";
        assert (selectorGroup.size() > 0) : "Requires at least one selector.";
        this.selectorGroup = new ImmutableList.Builder().addAll(selectorGroup).build();
        this.mediaQueryList = mediaQueries == null ? ImmutableList.of() : new ImmutableList.Builder().addAll(mediaQueries).build();
        this.propertyList = properties == null ? ImmutableList.of() : new ImmutableList.Builder().addAll(properties).build();
        this.children.add(new CSSTypedNode(CSSModelTreeType.SELECTOR_GROUP, this.selectorGroup));
        this.children.add(new CSSTypedNode(CSSModelTreeType.MEDIA_QUERY, this.mediaQueryList));
        this.children.add(new CSSTypedNode(CSSModelTreeType.PROPERTY_LIST, this.propertyList));
    }

    @Override
    public ImmutableList<ICSSMediaQueryCondition> getMediaQueryConditions() {
        return this.mediaQueryList;
    }

    @Override
    public ImmutableList<ICSSSelector> getSelectorGroup() {
        return this.selectorGroup;
    }

    @Override
    public ImmutableList<ICSSProperty> getProperties() {
        return this.propertyList;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.hasMediaQuery()) {
            result.append("@media ");
            result.append(Joiner.on((String)" and ").join(this.getMediaQueryConditions()));
            result.append(" {\n");
            result.append("    ");
        }
        String selectors = Joiner.on((String)",\n").join(this.getSelectorGroup());
        result.append(selectors).append(" {\n");
        for (ICSSProperty prop : this.getProperties()) {
            if (!this.hasMediaQuery()) {
                result.append("    ");
            }
            result.append("    ").append(prop.toString()).append("\n");
        }
        if (this.hasMediaQuery()) {
            result.append("    }\n");
        }
        result.append("}\n");
        return result.toString();
    }

    private boolean hasMediaQuery() {
        return !this.mediaQueryList.isEmpty();
    }
}

