/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import com.google.common.base.Strings;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.css.ConditionType;
import org.apache.flex.compiler.css.ICSSSelectorCondition;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSNodeBase;

public class CSSSelectorCondition
extends CSSNodeBase
implements ICSSSelectorCondition {
    private final String value;
    private final ConditionType type;

    protected CSSSelectorCondition(String value, ConditionType type, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.SELECTOR_CONDITION);
        assert (!Strings.isNullOrEmpty((String)value)) : "Selector condition value can't be empty.";
        assert (type != null) : "Selector condition type can't be null.";
        this.value = value;
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public ConditionType getConditionType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.type.prefix.concat(this.value);
    }
}

