/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpoint;
import org.apache.flink.table.store.file.Snapshot;

public class StaticFileStoreSplitEnumerator
implements SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> {
    private final SplitEnumeratorContext<FileStoreSourceSplit> context;
    @Nullable
    private final Snapshot snapshot;
    private final Queue<FileStoreSourceSplit> splits;

    public StaticFileStoreSplitEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, @Nullable Snapshot snapshot, Collection<FileStoreSourceSplit> splits) {
        this.context = context;
        this.snapshot = snapshot;
        this.splits = new LinkedList<FileStoreSourceSplit>(splits);
    }

    public void start() {
    }

    public void handleSplitRequest(int subtask, @Nullable String hostname) {
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        FileStoreSourceSplit split = this.splits.poll();
        if (split != null) {
            this.context.assignSplit((SourceSplit)split, subtask);
        } else {
            this.context.signalNoMoreSplits(subtask);
        }
    }

    public void addSplitsBack(List<FileStoreSourceSplit> backSplits, int subtaskId) {
        this.splits.addAll(backSplits);
    }

    public void addReader(int subtaskId) {
    }

    public PendingSplitsCheckpoint snapshotState(long checkpointId) {
        return new PendingSplitsCheckpoint(new ArrayList<FileStoreSourceSplit>(this.splits), this.snapshot == null ? -1L : this.snapshot.id());
    }

    public void close() {
    }

    @Nullable
    public Snapshot snapshot() {
        return this.snapshot;
    }
}

