/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.CatalogOptions;
import org.apache.flink.table.store.file.catalog.AbstractCatalog;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.catalog.CatalogLock;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.SchemaChange;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.hive.HiveCatalogLock;
import org.apache.flink.table.store.hive.HiveTypeUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.TableType;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Database;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class HiveCatalog
extends AbstractCatalog {
    private static final String INPUT_FORMAT_CLASS_NAME = "org.apache.flink.table.store.mapred.TableStoreInputFormat";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "org.apache.flink.table.store.mapred.TableStoreOutputFormat";
    private static final String SERDE_CLASS_NAME = "org.apache.flink.table.store.hive.TableStoreSerDe";
    private static final String STORAGE_HANDLER_CLASS_NAME = "org.apache.flink.table.store.hive.TableStoreHiveStorageHandler";
    private final HiveConf hiveConf;
    private final IMetaStoreClient client;

    public HiveCatalog(Configuration hadoopConfig) {
        this.hiveConf = new HiveConf(hadoopConfig, HiveConf.class);
        this.client = HiveCatalog.createClient(this.hiveConf);
    }

    public Optional<CatalogLock.Factory> lockFactory() {
        return this.lockEnabled() ? Optional.of(HiveCatalogLock.createFactory(this.hiveConf)) : Optional.empty();
    }

    private boolean lockEnabled() {
        return Boolean.parseBoolean(this.hiveConf.get(CatalogOptions.LOCK_ENABLED.key(), ((Boolean)CatalogOptions.LOCK_ENABLED.defaultValue()).toString()));
    }

    public List<String> listDatabases() {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all databases", e);
        }
    }

    public boolean databaseExists(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to determine if database " + databaseName + " exists", e);
        }
    }

    public void createDatabase(String name, boolean ignoreIfExists) throws Catalog.DatabaseAlreadyExistException {
        try {
            this.client.createDatabase(this.convertToDatabase(name));
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.DatabaseAlreadyExistException(name, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create database " + name, e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        try {
            if (!cascade && this.client.getAllTables(name).size() > 0) {
                throw new Catalog.DatabaseNotEmptyException(name);
            }
            this.client.dropDatabase(name, true, false, true);
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop database " + name, e);
        }
    }

    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (UnknownDBException e) {
            throw new Catalog.DatabaseNotExistException(databaseName, (Throwable)e);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables in database " + databaseName, e);
        }
    }

    public TableSchema getTableSchema(ObjectPath tablePath) throws Catalog.TableNotExistException {
        if (this.isTableStoreTableNotExisted(tablePath)) {
            throw new Catalog.TableNotExistException(tablePath);
        }
        Path tableLocation = this.getTableLocation(tablePath);
        return (TableSchema)new SchemaManager(tableLocation).latest().orElseThrow(() -> new RuntimeException("There is no table stored in " + tableLocation));
    }

    public boolean tableExists(ObjectPath tablePath) {
        try {
            this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to determine if table " + tablePath.getFullName() + " exists", e);
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        if (this.isTableStoreTableNotExisted(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(tablePath);
        }
        try {
            this.client.dropTable(tablePath.getDatabaseName(), tablePath.getObjectName(), true, false, true);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop table " + tablePath.getFullName(), e);
        }
    }

    public void createTable(ObjectPath tablePath, UpdateSchema updateSchema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        TableSchema schema;
        String databaseName = tablePath.getDatabaseName();
        if (!this.databaseExists(databaseName)) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.TableAlreadyExistException(tablePath);
        }
        try {
            schema = this.schemaManager(tablePath).commitNewVersion(updateSchema);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit changes of table " + tablePath.getFullName() + " to underlying files", e);
        }
        Table table = this.newHmsTable(tablePath);
        this.updateHmsTable(table, tablePath, schema);
        try {
            this.client.createTable(table);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create table " + tablePath.getFullName(), e);
        }
    }

    public void alterTable(ObjectPath tablePath, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        if (this.isTableStoreTableNotExisted(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(tablePath);
        }
        try {
            TableSchema schema = this.schemaManager(tablePath).commitChanges(changes);
            Table table = this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
            this.updateHmsTable(table, tablePath, schema);
            this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), table);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.client.close();
    }

    protected String warehouse() {
        return this.hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
    }

    private Database convertToDatabase(String name) {
        Database database = new Database();
        database.setName(name);
        database.setLocationUri(this.databasePath(name).toString());
        return database;
    }

    private Table newHmsTable(ObjectPath tablePath) {
        long currentTimeMillis = System.currentTimeMillis();
        Table table = new Table(tablePath.getObjectName(), tablePath.getDatabaseName(), System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, null, Collections.emptyList(), new HashMap<String, String>(), null, null, TableType.MANAGED_TABLE.toString());
        table.getParameters().put("storage_handler", STORAGE_HANDLER_CLASS_NAME);
        return table;
    }

    private void updateHmsTable(Table table, ObjectPath tablePath, TableSchema schema) {
        StorageDescriptor sd = this.convertToStorageDescriptor(tablePath, schema);
        table.setSd(sd);
    }

    private StorageDescriptor convertToStorageDescriptor(ObjectPath tablePath, TableSchema schema) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(schema.fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        sd.setLocation(this.getTableLocation(tablePath).toString());
        sd.setInputFormat(INPUT_FORMAT_CLASS_NAME);
        sd.setOutputFormat(OUTPUT_FORMAT_CLASS_NAME);
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setParameters(new HashMap<String, String>());
        serDeInfo.setSerializationLib(SERDE_CLASS_NAME);
        sd.setSerdeInfo(serDeInfo);
        return sd;
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.logicalTypeToTypeInfo(dataField.type().logicalType()).getTypeName(), dataField.description());
    }

    private boolean isTableStoreTableNotExisted(ObjectPath tablePath) {
        Table table;
        try {
            table = this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
        }
        catch (NoSuchObjectException e) {
            return true;
        }
        catch (TException e) {
            throw new RuntimeException("Cannot determine if table " + tablePath.getFullName() + " is a table store table.", e);
        }
        if (!INPUT_FORMAT_CLASS_NAME.equals(table.getSd().getInputFormat()) || !OUTPUT_FORMAT_CLASS_NAME.equals(table.getSd().getOutputFormat())) {
            throw new IllegalArgumentException("Table " + tablePath.getFullName() + " is not a table store table. It's input format is " + table.getSd().getInputFormat() + " and its output format is " + table.getSd().getOutputFormat());
        }
        return false;
    }

    private SchemaManager schemaManager(ObjectPath tablePath) {
        return new SchemaManager(this.getTableLocation(tablePath)).withLock(this.lock(tablePath));
    }

    private Lock lock(ObjectPath tablePath) {
        if (!this.lockEnabled()) {
            return null;
        }
        HiveCatalogLock lock2 = new HiveCatalogLock(this.client, HiveCatalogLock.checkMaxSleep(this.hiveConf), HiveCatalogLock.acquireTimeout(this.hiveConf));
        return Lock.fromCatalog((CatalogLock)lock2, (ObjectPath)tablePath);
    }

    static IMetaStoreClient createClient(HiveConf hiveConf) {
        IMetaStoreClient client;
        try {
            client = RetryingMetaStoreClient.getProxy(hiveConf, tbl -> null, HiveMetaStoreClient.class.getName());
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
        return StringUtils.isNullOrWhitespaceOnly((String)hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)) ? client : HiveMetaStoreClient.newSynchronizedClient(client);
    }
}

