/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.typeinfo.BaseCharUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.io.Text;

public class WritableHiveCharObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableHiveCharObjectInspector {
    public WritableHiveCharObjectInspector() {
    }

    public WritableHiveCharObjectInspector(CharTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveChar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            String str = ((Text)o).toString();
            return new HiveChar(str, ((CharTypeInfo)this.typeInfo).getLength());
        }
        HiveCharWritable writable = (HiveCharWritable)o;
        if (this.doesWritableMatchTypeParams(writable)) {
            return writable.getHiveChar();
        }
        return this.getPrimitiveWithParams(writable);
    }

    @Override
    public HiveCharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            String str = ((Text)o).toString();
            HiveCharWritable hcw = new HiveCharWritable();
            hcw.set(str, ((CharTypeInfo)this.typeInfo).getLength());
            return hcw;
        }
        HiveCharWritable writable = (HiveCharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveCharWritable)o)) {
            return writable;
        }
        return this.getWritableWithParams(writable);
    }

    private HiveChar getPrimitiveWithParams(HiveCharWritable val) {
        HiveChar hv = new HiveChar();
        hv.setValue(val.getHiveChar(), this.getMaxLength());
        return hv;
    }

    private HiveCharWritable getWritableWithParams(HiveCharWritable val) {
        HiveCharWritable newValue = new HiveCharWritable();
        newValue.set(val, this.getMaxLength());
        return newValue;
    }

    private boolean doesWritableMatchTypeParams(HiveCharWritable writable) {
        return BaseCharUtils.doesWritableMatchTypeParams(writable, (CharTypeInfo)this.typeInfo);
    }

    @Override
    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            String str = ((Text)o).toString();
            HiveCharWritable hcw = new HiveCharWritable();
            hcw.set(str, ((CharTypeInfo)this.typeInfo).getLength());
            return hcw;
        }
        HiveCharWritable writable = (HiveCharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveCharWritable)o)) {
            return new HiveCharWritable(writable);
        }
        return this.getWritableWithParams(writable);
    }

    @Override
    public Object set(Object o, HiveChar value) {
        if (value == null) {
            return null;
        }
        HiveCharWritable writable = (HiveCharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object set(Object o, String value) {
        if (value == null) {
            return null;
        }
        HiveCharWritable writable = (HiveCharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object create(HiveChar value) {
        HiveCharWritable ret = new HiveCharWritable();
        ret.set(value, this.getMaxLength());
        return ret;
    }

    public int getMaxLength() {
        return ((CharTypeInfo)this.typeInfo).getLength();
    }
}

