/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.store.file.data.DataFileMeta;

public class Increment {
    private static final List<DataFileMeta> EMPTY_NEW_FILES = Collections.emptyList();
    private static final List<DataFileMeta> EMPTY_COMPACT_BEFORE = Collections.emptyList();
    private static final List<DataFileMeta> EMPTY_COMPACT_AFTER = Collections.emptyList();
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;

    public static Increment forAppend(List<DataFileMeta> newFiles) {
        return new Increment(newFiles, EMPTY_COMPACT_BEFORE, EMPTY_COMPACT_AFTER);
    }

    public static Increment forCompact(List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter) {
        return new Increment(EMPTY_NEW_FILES, compactBefore, compactAfter);
    }

    public Increment(List<DataFileMeta> newFiles, List<DataFileMeta> beCompacted, List<DataFileMeta> compacted) {
        this.newFiles = Collections.unmodifiableList(newFiles);
        this.compactBefore = Collections.unmodifiableList(beCompacted);
        this.compactAfter = Collections.unmodifiableList(compacted);
    }

    public List<DataFileMeta> newFiles() {
        return this.newFiles;
    }

    public List<DataFileMeta> compactBefore() {
        return this.compactBefore;
    }

    public List<DataFileMeta> compactAfter() {
        return this.compactAfter;
    }

    public boolean isEmpty() {
        return this.newFiles.isEmpty() && this.compactBefore.isEmpty() && this.compactAfter.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Increment increment = (Increment)o;
        return Objects.equals(this.newFiles, increment.newFiles) && Objects.equals(this.compactBefore, increment.compactBefore) && Objects.equals(this.compactAfter, increment.compactAfter);
    }

    public int hashCode() {
        return Objects.hash(this.newFiles, this.compactBefore, this.compactAfter);
    }

    public String toString() {
        return "Increment{newFiles=" + this.newFiles + ", compactBefore=" + this.compactBefore + ", compactAfter=" + this.compactAfter + '}';
    }
}

