/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.fs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.IOUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class HadoopReadOnlyFileSystem
extends FileSystem {
    private final org.apache.flink.core.fs.FileSystem fs;

    public HadoopReadOnlyFileSystem(org.apache.flink.core.fs.FileSystem fs) {
        this.fs = fs;
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public org.apache.hadoop.fs.FSDataInputStream open(org.apache.hadoop.fs.Path path) throws IOException {
        return new org.apache.hadoop.fs.FSDataInputStream((InputStream)new FSDataWrappedInputStream(this.fs.open(HadoopReadOnlyFileSystem.toFlinkPath(path))));
    }

    public org.apache.hadoop.fs.FSDataInputStream open(org.apache.hadoop.fs.Path path, int bufferSize) throws IOException {
        return new org.apache.hadoop.fs.FSDataInputStream((InputStream)new FSDataWrappedInputStream(this.fs.open(HadoopReadOnlyFileSystem.toFlinkPath(path), bufferSize)));
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(org.apache.hadoop.fs.Path path) throws IOException {
        return HadoopReadOnlyFileSystem.toHadoopStatus(this.fs.getFileStatus(HadoopReadOnlyFileSystem.toFlinkPath(path)));
    }

    private static Path toFlinkPath(org.apache.hadoop.fs.Path path) {
        return new Path(path.toUri());
    }

    private static org.apache.hadoop.fs.Path toHadoopPath(Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    private static org.apache.hadoop.fs.FileStatus toHadoopStatus(FileStatus status) {
        return new org.apache.hadoop.fs.FileStatus(status.getLen(), status.isDir(), (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), null, null, null, HadoopReadOnlyFileSystem.toHadoopPath(status.getPath()));
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        throw new UnsupportedOperationException();
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(org.apache.hadoop.fs.Path path) {
        throw new UnsupportedOperationException();
    }

    public void setWorkingDirectory(org.apache.hadoop.fs.Path path) {
        throw new UnsupportedOperationException();
    }

    public org.apache.hadoop.fs.Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path path, FsPermission fsPermission) {
        throw new UnsupportedOperationException();
    }

    private static class FSDataWrappedInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private final FSDataInputStream fsDataInputStream;

        private FSDataWrappedInputStream(FSDataInputStream fsDataInputStream) {
            this.fsDataInputStream = fsDataInputStream;
        }

        @Override
        public int read() throws IOException {
            return this.fsDataInputStream.read();
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.fsDataInputStream.seek(position);
            return this.fsDataInputStream.read(buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.fsDataInputStream.seek(position);
            IOUtils.readFully(this.fsDataInputStream, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.readFully(position, buffer, 0, buffer.length);
        }

        public void seek(long pos) throws IOException {
            this.fsDataInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.fsDataInputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.fsDataInputStream.close();
        }
    }
}

