/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.evictors;

import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TimestampedValue;

@PublicEvolving
public class CountEvictor<W extends Window>
implements Evictor<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long maxCount;
    private final boolean doEvictAfter;

    private CountEvictor(long count, boolean doEvictAfter) {
        this.maxCount = count;
        this.doEvictAfter = doEvictAfter;
    }

    private CountEvictor(long count) {
        this.maxCount = count;
        this.doEvictAfter = false;
    }

    @Override
    public void evictBefore(Iterable<TimestampedValue<Object>> elements, int size, W window, Evictor.EvictorContext ctx) {
        if (!this.doEvictAfter) {
            this.evict(elements, size, ctx);
        }
    }

    @Override
    public void evictAfter(Iterable<TimestampedValue<Object>> elements, int size, W window, Evictor.EvictorContext ctx) {
        if (this.doEvictAfter) {
            this.evict(elements, size, ctx);
        }
    }

    private void evict(Iterable<TimestampedValue<Object>> elements, int size, Evictor.EvictorContext ctx) {
        if ((long)size <= this.maxCount) {
            return;
        }
        int evictedCount = 0;
        Iterator<TimestampedValue<Object>> iterator = elements.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if ((long)(++evictedCount) > (long)size - this.maxCount) break;
            iterator.remove();
        }
    }

    public static <W extends Window> CountEvictor<W> of(long maxCount) {
        return new CountEvictor<W>(maxCount);
    }

    public static <W extends Window> CountEvictor<W> of(long maxCount, boolean doEvictAfter) {
        return new CountEvictor<W>(maxCount, doEvictAfter);
    }
}

