/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.AndArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.AnyArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ComparableTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CompositeArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ConstraintArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExplicitArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.FamilyArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.LiteralArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OrArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OrInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OutputArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.RepeatingSequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.RootArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SubsequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SymbolArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.TypeLiteralArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.VaryingSequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.WildcardInputTypeStrategy;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public final class InputTypeStrategies {
    public static final WildcardInputTypeStrategy WILDCARD = new WildcardInputTypeStrategy();
    public static final InputTypeStrategy NO_ARGS = InputTypeStrategies.sequence(new ArgumentTypeStrategy[0]);
    public static final OutputArgumentTypeStrategy OUTPUT_IF_NULL = new OutputArgumentTypeStrategy();
    public static final AnyArgumentTypeStrategy ANY = new AnyArgumentTypeStrategy();
    public static final LiteralArgumentTypeStrategy LITERAL = new LiteralArgumentTypeStrategy(false);
    public static final LiteralArgumentTypeStrategy LITERAL_OR_NULL = new LiteralArgumentTypeStrategy(true);
    public static final TypeLiteralArgumentTypeStrategy TYPE_LITERAL = new TypeLiteralArgumentTypeStrategy();
    public static final ArgumentTypeStrategy COMPOSITE = new CompositeArgumentTypeStrategy();
    public static final ArgumentTypeStrategy COMMON_ARG = new CommonArgumentTypeStrategy(false);
    public static final ArgumentTypeStrategy COMMON_ARG_NULLABLE = new CommonArgumentTypeStrategy(true);

    public static InputTypeStrategy sequence(ArgumentTypeStrategy ... strategies) {
        return new SequenceInputTypeStrategy(Arrays.asList(strategies), null);
    }

    public static InputTypeStrategy sequence(String[] argumentNames, ArgumentTypeStrategy[] strategies) {
        return new SequenceInputTypeStrategy(Arrays.asList(strategies), Arrays.asList(argumentNames));
    }

    public static InputTypeStrategy varyingSequence(ArgumentTypeStrategy ... strategies) {
        return new VaryingSequenceInputTypeStrategy(Arrays.asList(strategies), null);
    }

    public static InputTypeStrategy varyingSequence(String[] argumentNames, ArgumentTypeStrategy[] strategies) {
        return new VaryingSequenceInputTypeStrategy(Arrays.asList(strategies), Arrays.asList(argumentNames));
    }

    public static InputTypeStrategy repeatingSequence(ArgumentTypeStrategy ... strategies) {
        return new RepeatingSequenceInputTypeStrategy(Arrays.asList(strategies));
    }

    public static InputTypeStrategy explicitSequence(DataType ... expectedDataTypes) {
        List strategies = Arrays.stream(expectedDataTypes).map(InputTypeStrategies::explicit).collect(Collectors.toList());
        return new SequenceInputTypeStrategy(strategies, null);
    }

    public static InputTypeStrategy explicitSequence(String[] argumentNames, DataType[] expectedDataTypes) {
        List strategies = Arrays.stream(expectedDataTypes).map(InputTypeStrategies::explicit).collect(Collectors.toList());
        return new SequenceInputTypeStrategy(strategies, Arrays.asList(argumentNames));
    }

    public static SubsequenceInputTypeStrategy.SubsequenceStrategyBuilder compositeSequence() {
        return new SubsequenceInputTypeStrategy.SubsequenceStrategyBuilder();
    }

    public static InputTypeStrategy or(InputTypeStrategy ... strategies) {
        return new OrInputTypeStrategy(Arrays.asList(strategies));
    }

    public static InputTypeStrategy wildcardWithCount(ArgumentCount argumentCount) {
        return new WildcardInputTypeStrategy(argumentCount);
    }

    public static InputTypeStrategy comparable(ConstantArgumentCount argumentCount, StructuredType.StructuredComparison requiredComparison) {
        return new ComparableTypeStrategy(argumentCount, requiredComparison);
    }

    public static ExplicitArgumentTypeStrategy explicit(DataType expectedDataType) {
        return new ExplicitArgumentTypeStrategy(expectedDataType);
    }

    public static RootArgumentTypeStrategy logical(LogicalTypeRoot expectedRoot) {
        return new RootArgumentTypeStrategy(expectedRoot, null);
    }

    public static RootArgumentTypeStrategy logical(LogicalTypeRoot expectedRoot, boolean expectedNullability) {
        return new RootArgumentTypeStrategy(expectedRoot, expectedNullability);
    }

    public static FamilyArgumentTypeStrategy logical(LogicalTypeFamily expectedFamily) {
        return new FamilyArgumentTypeStrategy(expectedFamily, null);
    }

    public static FamilyArgumentTypeStrategy logical(LogicalTypeFamily expectedFamily, boolean expectedNullability) {
        return new FamilyArgumentTypeStrategy(expectedFamily, expectedNullability);
    }

    public static ConstraintArgumentTypeStrategy constraint(String constraintMessage, Function<List<DataType>, Boolean> evaluator) {
        return new ConstraintArgumentTypeStrategy(constraintMessage, evaluator);
    }

    public static AndArgumentTypeStrategy and(ArgumentTypeStrategy ... strategies) {
        return new AndArgumentTypeStrategy(Arrays.asList(strategies));
    }

    public static OrArgumentTypeStrategy or(ArgumentTypeStrategy ... strategies) {
        return new OrArgumentTypeStrategy(Arrays.asList(strategies));
    }

    public static SymbolArgumentTypeStrategy symbol(Class<? extends Enum<? extends TableSymbol>> clazz) {
        return new SymbolArgumentTypeStrategy(clazz);
    }

    public static InputTypeStrategy commonType(int count) {
        return new CommonInputTypeStrategy(ConstantArgumentCount.of(count));
    }

    private InputTypeStrategies() {
    }
}

