/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.interval;

import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.interval.IntervalJoinFunction;
import org.apache.flink.table.runtime.operators.join.interval.TimeIntervalJoin;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;

public final class ProcTimeIntervalJoin
extends TimeIntervalJoin {
    private static final long serialVersionUID = 9204647938032023101L;

    public ProcTimeIntervalJoin(FlinkJoinType joinType, long leftLowerBound, long leftUpperBound, InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, IntervalJoinFunction genJoinFunc) {
        super(joinType, leftLowerBound, leftUpperBound, 0L, leftType, rightType, genJoinFunc);
    }

    @Override
    void updateOperatorTime(KeyedCoProcessFunction.Context ctx) {
        this.rightOperatorTime = this.leftOperatorTime = ctx.timerService().currentProcessingTime();
    }

    @Override
    long getTimeForLeftStream(KeyedCoProcessFunction.Context ctx, RowData row) {
        return this.leftOperatorTime;
    }

    @Override
    long getTimeForRightStream(KeyedCoProcessFunction.Context ctx, RowData row) {
        return this.rightOperatorTime;
    }

    @Override
    void registerTimer(KeyedCoProcessFunction.Context ctx, long cleanupTime) {
        ctx.timerService().registerProcessingTimeTimer(cleanupTime);
    }
}

