/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowTimeRowsBoundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RowTimeRowsBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private transient JoinedRowData output;
    private transient ValueState<Long> lastTriggeringTsState;
    private transient ValueState<Long> counterState;
    private transient ValueState<RowData> accState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient AggsHandleFunction function;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private transient Counter numLateRecordsDropped;

    @VisibleForTesting
    protected Counter getCounter() {
        return this.numLateRecordsDropped;
    }

    public RowTimeRowsBoundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingOffset, int rowTimeIdx) {
        super(minRetentionTime, maxRetentionTime);
        Preconditions.checkNotNull(precedingOffset);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        ValueStateDescriptor<Long> lastTriggeringTsDescriptor = new ValueStateDescriptor<Long>("lastTriggeringTsState", Types.LONG);
        this.lastTriggeringTsState = this.getRuntimeContext().getState(lastTriggeringTsDescriptor);
        ValueStateDescriptor<Long> dataCountStateDescriptor = new ValueStateDescriptor<Long>("processedCountState", Types.LONG);
        this.counterState = this.getRuntimeContext().getState(dataCountStateDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor<RowData> accStateDesc = new ValueStateDescriptor<RowData>("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo<RowData> rowListTypeInfo = new ListTypeInfo<RowData>(inputType);
        MapStateDescriptor<Long, RowData> inputStateDesc = new MapStateDescriptor<Long, RowData>("inputState", Types.LONG, (TypeInformation<RowData>)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
        this.numLateRecordsDropped = this.getRuntimeContext().getMetricGroup().counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
    }

    @Override
    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = this.lastTriggeringTsState.value();
        if (lastTriggeringTs == null) {
            lastTriggeringTs = 0L;
        }
        if (triggeringTs > lastTriggeringTs) {
            List<RowData> data = this.inputState.get(triggeringTs);
            if (null != data) {
                data.add(input);
                this.inputState.put(triggeringTs, data);
            } else {
                data = new ArrayList<RowData>();
                data.add(input);
                this.inputState.put(triggeringTs, data);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        } else {
            this.numLateRecordsDropped.inc();
        }
    }

    @Override
    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled) {
                Iterator<Long> keysIt = this.inputState.keys().iterator();
                Long lastProcessedTime = this.lastTriggeringTsState.value();
                if (lastProcessedTime == null) {
                    lastProcessedTime = 0L;
                }
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (keysIt.next() <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState(this.inputState, this.accState, this.counterState, this.lastTriggeringTsState);
                    this.function.cleanup();
                } else {
                    this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List<RowData> inputs = this.inputState.get(timestamp);
        if (null != inputs) {
            RowData accumulators;
            Long dataCount = this.counterState.value();
            if (dataCount == null) {
                dataCount = 0L;
            }
            if ((accumulators = this.accState.value()) == null) {
                accumulators = this.function.createAccumulators();
            }
            this.function.setAccumulators(accumulators);
            List<RowData> retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                RowData input = inputs.get(i);
                RowData retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (null == retractList) {
                        retractTs = Long.MAX_VALUE;
                        for (Long dataTs : this.inputState.keys()) {
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                            retractList = this.inputState.get(dataTs);
                        }
                    }
                    if (retractList != null) {
                        retractRow = (RowData)retractList.get(retractCnt);
                        if (retractList.size() == ++retractCnt) {
                            this.inputState.remove(retractTs);
                            retractList = null;
                            retractCnt = 0;
                        }
                    }
                } else {
                    dataCount = dataCount + 1L;
                }
                if (null != retractRow) {
                    this.function.retract(retractRow);
                }
                this.function.accumulate(input);
                this.output.replace(input, this.function.getValue());
                out.collect(this.output);
            }
            if (this.inputState.contains(retractTs) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.inputState.put(retractTs, retractList);
            }
            this.counterState.update(dataCount);
            accumulators = this.function.getAccumulators();
            this.accState.update(accumulators);
        }
        this.lastTriggeringTsState.update(timestamp);
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
    }

    @Override
    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

