/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableScan;

public class FileStoreSourceSplitGenerator {
    private final char[] currentId = "0000000000".toCharArray();

    public List<FileStoreSourceSplit> createSplits(TableScan.Plan plan) {
        return plan.splits().stream().map(s -> new FileStoreSourceSplit(this.getNextId(), (Split)s)).collect(Collectors.toList());
    }

    protected final String getNextId() {
        FileStoreSourceSplitGenerator.incrementCharArrayByOne(this.currentId, this.currentId.length - 1);
        return new String(this.currentId);
    }

    private static void incrementCharArrayByOne(char[] array, int pos) {
        if (pos < 0) {
            throw new RuntimeException("Produce too many splits.");
        }
        int c = array[pos];
        if ((c = (char)(c + '\u0001')) > 57) {
            c = 48;
            FileStoreSourceSplitGenerator.incrementCharArrayByOne(array, pos - 1);
        }
        array[pos] = c;
    }
}

