/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.AbstractFileRecordIterator;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.RecordReader;

public class RowDataFileRecordReader
implements RecordReader<RowData> {
    private final BulkFormat.Reader<RowData> reader;
    @Nullable
    private final int[] indexMapping;

    public RowDataFileRecordReader(Path path, BulkFormat<RowData, FileSourceSplit> readerFactory, @Nullable int[] indexMapping) throws IOException {
        this.reader = FileUtils.createFormatReader(readerFactory, path);
        this.indexMapping = indexMapping;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<RowData> readBatch() throws IOException {
        BulkFormat.RecordIterator iterator = this.reader.readBatch();
        return iterator == null ? null : new RowDataFileRecordIterator(iterator, this.indexMapping);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class RowDataFileRecordIterator
    extends AbstractFileRecordIterator<RowData> {
        private final BulkFormat.RecordIterator<RowData> iterator;

        private RowDataFileRecordIterator(BulkFormat.RecordIterator<RowData> iterator, @Nullable int[] indexMapping) {
            super(indexMapping);
            this.iterator = iterator;
        }

        @Override
        public RowData next() throws IOException {
            RecordAndPosition result = this.iterator.next();
            return result == null ? null : this.mappingRowData((RowData)result.getRecord());
        }

        @Override
        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

