/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.util.Comparator;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.FileStore;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.FileStoreCommitImpl;
import org.apache.flink.table.store.file.operation.FileStoreExpireImpl;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.types.logical.RowType;

public abstract class AbstractFileStore<T>
implements FileStore<T> {
    protected final SchemaManager schemaManager;
    protected final long schemaId;
    protected final CoreOptions options;
    protected final RowType partitionType;

    public AbstractFileStore(SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.options = options;
        this.partitionType = partitionType;
    }

    public FileStorePathFactory pathFactory() {
        return new FileStorePathFactory(this.options.path(), this.partitionType, this.options.partitionDefaultName(), this.options.fileFormat().getFormatIdentifier());
    }

    @Override
    public SnapshotManager snapshotManager() {
        return new SnapshotManager(this.options.path());
    }

    @VisibleForTesting
    public ManifestFile.Factory manifestFileFactory() {
        return new ManifestFile.Factory(this.schemaManager, this.schemaId, this.partitionType, this.options.manifestFormat(), this.pathFactory(), this.options.manifestTargetSize().getBytes());
    }

    @VisibleForTesting
    public ManifestList.Factory manifestListFactory() {
        return new ManifestList.Factory(this.partitionType, this.options.manifestFormat(), this.pathFactory());
    }

    @Override
    public RowType partitionType() {
        return this.partitionType;
    }

    @Override
    public CoreOptions options() {
        return this.options;
    }

    @Override
    public FileStoreCommitImpl newCommit(String commitUser) {
        return new FileStoreCommitImpl(this.schemaId, commitUser, this.partitionType, this.pathFactory(), this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory(), this.newScan(), this.options.bucket(), this.options.manifestTargetSize(), this.options.manifestMergeMinCount(), this.newKeyComparator());
    }

    @Override
    public FileStoreExpireImpl newExpire() {
        return new FileStoreExpireImpl(this.options.snapshotNumRetainMin(), this.options.snapshotNumRetainMax(), this.options.snapshotTimeRetain().toMillis(), this.pathFactory(), this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory());
    }

    public abstract Comparator<RowData> newKeyComparator();
}

