/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.log;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.log.LogSinkProvider;
import org.apache.flink.table.store.log.LogSourceProvider;
import org.apache.flink.types.RowKind;

public interface LogStoreTableFactory
extends DynamicTableFactory {
    public Map<String, String> enrichOptions(DynamicTableFactory.Context var1);

    public void onCreateTable(DynamicTableFactory.Context var1, int var2, boolean var3);

    public void onDropTable(DynamicTableFactory.Context var1, boolean var2);

    public LogSourceProvider createSourceProvider(DynamicTableFactory.Context var1, DynamicTableSource.Context var2, @Nullable int[][] var3);

    public LogSinkProvider createSinkProvider(DynamicTableFactory.Context var1, DynamicTableSink.Context var2);

    public static LogStoreTableFactory discoverLogStoreFactory(ClassLoader cl, String identifier) {
        return (LogStoreTableFactory)FactoryUtil.discoverFactory((ClassLoader)cl, LogStoreTableFactory.class, (String)identifier);
    }

    public static DecodingFormat<DeserializationSchema<RowData>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, CoreOptions.LOG_KEY_FORMAT);
        LogStoreTableFactory.validateKeyFormat((Format)format, (String)helper.getOptions().get(CoreOptions.LOG_KEY_FORMAT));
        return format;
    }

    public static EncodingFormat<SerializationSchema<RowData>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, CoreOptions.LOG_KEY_FORMAT);
        LogStoreTableFactory.validateKeyFormat((Format)format, (String)helper.getOptions().get(CoreOptions.LOG_KEY_FORMAT));
        return format;
    }

    public static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, CoreOptions.LOG_FORMAT);
        LogStoreTableFactory.validateValueFormat((Format)format, (String)helper.getOptions().get(CoreOptions.LOG_FORMAT));
        return format;
    }

    public static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, CoreOptions.LOG_FORMAT);
        LogStoreTableFactory.validateValueFormat((Format)format, (String)helper.getOptions().get(CoreOptions.LOG_FORMAT));
        return format;
    }

    public static void validateKeyFormat(Format format, String name) {
        if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", name, format.getChangelogMode()));
        }
    }

    public static void validateValueFormat(Format format, String name) {
        if (!format.getChangelogMode().equals((Object)ChangelogMode.all())) {
            throw new ValidationException(String.format("A value format should deal with all records. But %s has a changelog mode of %s.", name, format.getChangelogMode()));
        }
    }
}

