/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.operation.KeyValueFileStoreRead;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;

public abstract class KeyValueTableRead
implements TableRead {
    protected final KeyValueFileStoreRead read;

    protected KeyValueTableRead(KeyValueFileStoreRead read) {
        this.read = read;
    }

    @Override
    public RecordReader<RowData> createReader(Split split) throws IOException {
        return new RowDataRecordReader(this.read.createReader((DataSplit)split));
    }

    protected abstract RecordReader.RecordIterator<RowData> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> var1);

    private class RowDataRecordReader
    implements RecordReader<RowData> {
        private final RecordReader<KeyValue> wrapped;

        private RowDataRecordReader(RecordReader<KeyValue> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        @Nullable
        public RecordReader.RecordIterator<RowData> readBatch() throws IOException {
            RecordReader.RecordIterator<KeyValue> batch = this.wrapped.readBatch();
            return batch == null ? null : KeyValueTableRead.this.rowDataRecordIteratorFromKv(batch);
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }
    }
}

