/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.events.ListenerEvent;

public class InsertEvent
extends ListenerEvent {
    private final String db;
    private final String table;
    private final Map<String, String> keyValues;
    private final List<String> files;
    private List<String> fileChecksums = new ArrayList<String>();

    public InsertEvent(String db, String table, List<String> partVals, InsertEventRequestData insertData, boolean status, HiveMetaStore.HMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        this.db = db;
        this.table = table;
        this.files = insertData.getFilesAdded();
        Table t = handler.get_table(db, table);
        this.keyValues = new LinkedHashMap<String, String>();
        if (partVals != null) {
            for (int i = 0; i < partVals.size(); ++i) {
                this.keyValues.put(t.getPartitionKeys().get(i).getName(), partVals.get(i));
            }
        }
        if (insertData.isSetFilesAddedChecksum()) {
            this.fileChecksums = insertData.getFilesAddedChecksum();
        }
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getPartitionKeyValues() {
        return this.keyValues;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getFileChecksums() {
        return this.fileChecksums;
    }
}

