/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common;

import java.util.Collection;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BlobStorageUtils {
    private static final boolean DISABLE_BLOBSTORAGE_AS_SCRATCHDIR = false;

    public static boolean isBlobStoragePath(Configuration conf, Path path) {
        return path != null && BlobStorageUtils.isBlobStorageScheme(conf, path.toUri().getScheme());
    }

    public static boolean isBlobStorageFileSystem(Configuration conf, FileSystem fs) {
        return fs != null && BlobStorageUtils.isBlobStorageScheme(conf, fs.getScheme());
    }

    public static boolean isBlobStorageScheme(Configuration conf, String scheme) {
        Collection supportedBlobStoreSchemes = conf.getStringCollection(HiveConf.ConfVars.HIVE_BLOBSTORE_SUPPORTED_SCHEMES.varname);
        return supportedBlobStoreSchemes.contains(scheme);
    }

    public static boolean isBlobStorageAsScratchDir(Configuration conf) {
        return conf.getBoolean(HiveConf.ConfVars.HIVE_BLOBSTORE_USE_BLOBSTORE_AS_SCRATCHDIR.varname, false);
    }

    public static boolean areOptimizationsEnabled(Configuration conf) {
        return conf.getBoolean(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.defaultBoolVal);
    }
}

