/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Database;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Function;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterCatalogMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.CreateCatalogMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropCatalogMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.conf.Configuration;

public abstract class MessageFactory {
    public static final String ADD_PARTITION_EVENT = "ADD_PARTITION";
    public static final String ALTER_PARTITION_EVENT = "ALTER_PARTITION";
    public static final String DROP_PARTITION_EVENT = "DROP_PARTITION";
    public static final String CREATE_TABLE_EVENT = "CREATE_TABLE";
    public static final String ALTER_TABLE_EVENT = "ALTER_TABLE";
    public static final String DROP_TABLE_EVENT = "DROP_TABLE";
    public static final String CREATE_DATABASE_EVENT = "CREATE_DATABASE";
    public static final String ALTER_DATABASE_EVENT = "ALTER_DATABASE";
    public static final String DROP_DATABASE_EVENT = "DROP_DATABASE";
    public static final String INSERT_EVENT = "INSERT";
    public static final String CREATE_FUNCTION_EVENT = "CREATE_FUNCTION";
    public static final String DROP_FUNCTION_EVENT = "DROP_FUNCTION";
    public static final String ADD_PRIMARYKEY_EVENT = "ADD_PRIMARYKEY";
    public static final String ADD_FOREIGNKEY_EVENT = "ADD_FOREIGNKEY";
    public static final String ADD_UNIQUECONSTRAINT_EVENT = "ADD_UNIQUECONSTRAINT";
    public static final String ADD_NOTNULLCONSTRAINT_EVENT = "ADD_NOTNULLCONSTRAINT";
    public static final String DROP_CONSTRAINT_EVENT = "DROP_CONSTRAINT";
    public static final String CREATE_ISCHEMA_EVENT = "CREATE_ISCHEMA";
    public static final String ALTER_ISCHEMA_EVENT = "ALTER_ISCHEMA";
    public static final String DROP_ISCHEMA_EVENT = "DROP_ISCHEMA";
    public static final String ADD_SCHEMA_VERSION_EVENT = "ADD_SCHEMA_VERSION";
    public static final String ALTER_SCHEMA_VERSION_EVENT = "ALTER_SCHEMA_VERSION";
    public static final String DROP_SCHEMA_VERSION_EVENT = "DROP_SCHEMA_VERSION";
    public static final String CREATE_CATALOG_EVENT = "CREATE_CATALOG";
    public static final String DROP_CATALOG_EVENT = "DROP_CATALOG";
    public static final String OPEN_TXN_EVENT = "OPEN_TXN";
    public static final String COMMIT_TXN_EVENT = "COMMIT_TXN";
    public static final String ABORT_TXN_EVENT = "ABORT_TXN";
    public static final String ALLOC_WRITE_ID_EVENT = "ALLOC_WRITE_ID_EVENT";
    public static final String ALTER_CATALOG_EVENT = "ALTER_CATALOG";
    private static MessageFactory instance = null;
    protected static final Configuration conf = MetastoreConf.newMetastoreConf();
    protected static final String MS_SERVER_URL = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS, "");
    protected static final String MS_SERVICE_PRINCIPAL = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL, "");

    public static MessageFactory getInstance() {
        if (instance == null) {
            instance = MessageFactory.getInstance(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.EVENT_MESSAGE_FACTORY));
        }
        return instance;
    }

    private static MessageFactory getInstance(String className) {
        try {
            return JavaUtils.newInstance(JavaUtils.getClass(className, MessageFactory.class));
        }
        catch (MetaException e) {
            throw new IllegalStateException("Could not construct MessageFactory implementation: ", e);
        }
    }

    public static MessageDeserializer getDeserializer(String format, String version) {
        return MessageFactory.getInstance(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.EVENT_MESSAGE_FACTORY)).getDeserializer();
    }

    public abstract MessageDeserializer getDeserializer();

    public abstract String getMessageFormat();

    public abstract CreateDatabaseMessage buildCreateDatabaseMessage(Database var1);

    public abstract AlterDatabaseMessage buildAlterDatabaseMessage(Database var1, Database var2);

    public abstract DropDatabaseMessage buildDropDatabaseMessage(Database var1);

    public abstract CreateTableMessage buildCreateTableMessage(Table var1, Iterator<String> var2);

    public abstract AlterTableMessage buildAlterTableMessage(Table var1, Table var2, boolean var3);

    public abstract DropTableMessage buildDropTableMessage(Table var1);

    public abstract AddPartitionMessage buildAddPartitionMessage(Table var1, Iterator<Partition> var2, Iterator<PartitionFiles> var3);

    public abstract AlterPartitionMessage buildAlterPartitionMessage(Table var1, Partition var2, Partition var3, boolean var4);

    public abstract DropPartitionMessage buildDropPartitionMessage(Table var1, Iterator<Partition> var2);

    public abstract CreateFunctionMessage buildCreateFunctionMessage(Function var1);

    public abstract DropFunctionMessage buildDropFunctionMessage(Function var1);

    public abstract InsertMessage buildInsertMessage(Table var1, Partition var2, boolean var3, Iterator<String> var4);

    public abstract OpenTxnMessage buildOpenTxnMessage(Long var1, Long var2);

    public abstract CommitTxnMessage buildCommitTxnMessage(Long var1);

    public abstract AbortTxnMessage buildAbortTxnMessage(Long var1);

    public abstract AllocWriteIdMessage buildAllocWriteIdMessage(List<TxnToWriteId> var1, String var2, String var3);

    public abstract AddPrimaryKeyMessage buildAddPrimaryKeyMessage(List<SQLPrimaryKey> var1);

    public abstract AddForeignKeyMessage buildAddForeignKeyMessage(List<SQLForeignKey> var1);

    public abstract AddUniqueConstraintMessage buildAddUniqueConstraintMessage(List<SQLUniqueConstraint> var1);

    public abstract AddNotNullConstraintMessage buildAddNotNullConstraintMessage(List<SQLNotNullConstraint> var1);

    public abstract DropConstraintMessage buildDropConstraintMessage(String var1, String var2, String var3);

    public abstract CreateCatalogMessage buildCreateCatalogMessage(Catalog var1);

    public abstract DropCatalogMessage buildDropCatalogMessage(Catalog var1);

    public abstract AlterCatalogMessage buildAlterCatalogMessage(Catalog var1, Catalog var2);
}

