/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.query.KvStateInfo;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateEntry<K, N, V> {
    private final InternalKvState<K, N, V> state;
    private final KvStateInfo<K, N, V> stateInfo;
    private final boolean areSerializersStateless;
    private final ConcurrentMap<Thread, KvStateInfo<K, N, V>> serializerCache;
    private final ClassLoader userClassLoader;

    public KvStateEntry(InternalKvState<K, N, V> state, ClassLoader userClassLoader) {
        this.state = Preconditions.checkNotNull(state);
        this.stateInfo = new KvStateInfo<K, N, V>(state.getKeySerializer(), state.getNamespaceSerializer(), state.getValueSerializer());
        this.serializerCache = new ConcurrentHashMap<Thread, KvStateInfo<K, N, V>>();
        this.userClassLoader = userClassLoader;
        this.areSerializersStateless = this.stateInfo.duplicate() == this.stateInfo;
    }

    public InternalKvState<K, N, V> getState() {
        return this.state;
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public KvStateInfo<K, N, V> getInfoForCurrentThread() {
        return this.areSerializersStateless ? this.stateInfo : this.serializerCache.computeIfAbsent(Thread.currentThread(), t -> this.stateInfo.duplicate());
    }

    public void clear() {
        this.serializerCache.clear();
    }

    @VisibleForTesting
    public int getCacheSize() {
        return this.serializerCache.size();
    }
}

