/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class OperatorStreamStateHandle
implements OperatorStateHandle {
    private static final long serialVersionUID = 35876522969227335L;
    private final Map<String, OperatorStateHandle.StateMetaInfo> stateNameToPartitionOffsets;
    private final StreamStateHandle delegateStateHandle;

    public OperatorStreamStateHandle(Map<String, OperatorStateHandle.StateMetaInfo> stateNameToPartitionOffsets, StreamStateHandle delegateStateHandle) {
        this.delegateStateHandle = Preconditions.checkNotNull(delegateStateHandle);
        this.stateNameToPartitionOffsets = Preconditions.checkNotNull(stateNameToPartitionOffsets);
    }

    @Override
    public Map<String, OperatorStateHandle.StateMetaInfo> getStateNameToPartitionOffsets() {
        return this.stateNameToPartitionOffsets;
    }

    @Override
    public void discardState() throws Exception {
        this.delegateStateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.delegateStateHandle.getStateSize();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.delegateStateHandle.openInputStream();
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return this.delegateStateHandle.asBytesIfInMemory();
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return this.delegateStateHandle.getStreamStateHandleID();
    }

    @Override
    public StreamStateHandle getDelegateStateHandle() {
        return this.delegateStateHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorStreamStateHandle)) {
            return false;
        }
        OperatorStreamStateHandle that = (OperatorStreamStateHandle)o;
        if (this.stateNameToPartitionOffsets.size() != that.stateNameToPartitionOffsets.size()) {
            return false;
        }
        for (Map.Entry<String, OperatorStateHandle.StateMetaInfo> entry : this.stateNameToPartitionOffsets.entrySet()) {
            if (entry.getValue().equals(that.stateNameToPartitionOffsets.get(entry.getKey()))) continue;
            return false;
        }
        return this.delegateStateHandle.equals(that.delegateStateHandle);
    }

    public int hashCode() {
        int result = this.delegateStateHandle.hashCode();
        for (Map.Entry<String, OperatorStateHandle.StateMetaInfo> entry : this.stateNameToPartitionOffsets.entrySet()) {
            int entryHash = entry.getKey().hashCode();
            if (entry.getValue() != null) {
                entryHash += entry.getValue().hashCode();
            }
            result = 31 * result + entryHash;
        }
        return result;
    }

    public String toString() {
        return "OperatorStateHandle{stateNameToPartitionOffsets=" + this.stateNameToPartitionOffsets + ", delegateStateHandle=" + this.delegateStateHandle + '}';
    }
}

