/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class MapDataSerializer
extends TypeSerializer<MapData> {
    private final LogicalType keyType;
    private final LogicalType valueType;
    private final TypeSerializer keySerializer;
    private final TypeSerializer valueSerializer;
    private final ArrayData.ElementGetter keyGetter;
    private final ArrayData.ElementGetter valueGetter;
    private transient BinaryArrayData reuseKeyArray;
    private transient BinaryArrayData reuseValueArray;
    private transient BinaryArrayWriter reuseKeyWriter;
    private transient BinaryArrayWriter reuseValueWriter;

    public MapDataSerializer(LogicalType keyType, LogicalType valueType) {
        this(keyType, valueType, InternalSerializers.create(keyType), InternalSerializers.create(valueType));
    }

    private MapDataSerializer(LogicalType keyType, LogicalType valueType, TypeSerializer keySerializer, TypeSerializer valueSerializer) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyGetter = ArrayData.createElementGetter(keyType);
        this.valueGetter = ArrayData.createElementGetter(valueType);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<MapData> duplicate() {
        return new MapDataSerializer(this.keyType, this.valueType, this.keySerializer.duplicate(), this.valueSerializer.duplicate());
    }

    @Override
    public MapData createInstance() {
        return new BinaryMapData();
    }

    @Override
    public MapData copy(MapData from) {
        if (from instanceof BinaryMapData) {
            return ((BinaryMapData)from).copy();
        }
        return this.toBinaryMap(from);
    }

    @Override
    public MapData copy(MapData from, MapData reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(MapData record, DataOutputView target) throws IOException {
        BinaryMapData binaryMap = this.toBinaryMap(record);
        target.writeInt(binaryMap.getSizeInBytes());
        BinarySegmentUtils.copyToView(binaryMap.getSegments(), binaryMap.getOffset(), binaryMap.getSizeInBytes(), target);
    }

    public BinaryMapData toBinaryMap(MapData from) {
        if (from instanceof BinaryMapData) {
            return (BinaryMapData)from;
        }
        int numElements = from.size();
        if (this.reuseKeyArray == null) {
            this.reuseKeyArray = new BinaryArrayData();
        }
        if (this.reuseValueArray == null) {
            this.reuseValueArray = new BinaryArrayData();
        }
        if (this.reuseKeyWriter == null || this.reuseKeyWriter.getNumElements() != numElements) {
            this.reuseKeyWriter = new BinaryArrayWriter(this.reuseKeyArray, numElements, BinaryArrayData.calculateFixLengthPartSize(this.keyType));
        } else {
            this.reuseKeyWriter.reset();
        }
        if (this.reuseValueWriter == null || this.reuseValueWriter.getNumElements() != numElements) {
            this.reuseValueWriter = new BinaryArrayWriter(this.reuseValueArray, numElements, BinaryArrayData.calculateFixLengthPartSize(this.valueType));
        } else {
            this.reuseValueWriter.reset();
        }
        ArrayData keyArray = from.keyArray();
        ArrayData valueArray = from.valueArray();
        for (int i = 0; i < from.size(); ++i) {
            Object key = this.keyGetter.getElementOrNull(keyArray, i);
            Object value = this.valueGetter.getElementOrNull(valueArray, i);
            if (key == null) {
                this.reuseKeyWriter.setNullAt(i, this.keyType);
            } else {
                BinaryWriter.write(this.reuseKeyWriter, i, key, this.keyType, this.keySerializer);
            }
            if (value == null) {
                this.reuseValueWriter.setNullAt(i, this.valueType);
                continue;
            }
            BinaryWriter.write(this.reuseValueWriter, i, value, this.valueType, this.valueSerializer);
        }
        this.reuseKeyWriter.complete();
        this.reuseValueWriter.complete();
        return BinaryMapData.valueOf(this.reuseKeyArray, this.reuseValueArray);
    }

    @Override
    public MapData deserialize(DataInputView source) throws IOException {
        return this.deserializeReuse(new BinaryMapData(), source);
    }

    @Override
    public MapData deserialize(MapData reuse, DataInputView source) throws IOException {
        return this.deserializeReuse(reuse instanceof BinaryMapData ? (BinaryMapData)reuse : new BinaryMapData(), source);
    }

    private BinaryMapData deserializeReuse(BinaryMapData reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, bytes.length);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapDataSerializer that = (MapDataSerializer)o;
        return this.keyType.equals(that.keyType) && this.valueType.equals(that.valueType);
    }

    @Override
    public int hashCode() {
        int result = this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    @VisibleForTesting
    public TypeSerializer getKeySerializer() {
        return this.keySerializer;
    }

    @VisibleForTesting
    public TypeSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public TypeSerializerSnapshot<MapData> snapshotConfiguration() {
        return new MapDataSerializerSnapshot(this.keyType, this.valueType, this.keySerializer, this.valueSerializer);
    }

    public static final class MapDataSerializerSnapshot
    implements TypeSerializerSnapshot<MapData> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType previousKeyType;
        private LogicalType previousValueType;
        private TypeSerializer previousKeySerializer;
        private TypeSerializer previousValueSerializer;

        public MapDataSerializerSnapshot() {
        }

        MapDataSerializerSnapshot(LogicalType keyT, LogicalType valueT, TypeSerializer keySer, TypeSerializer valueSer) {
            this.previousKeyType = keyT;
            this.previousValueType = valueT;
            this.previousKeySerializer = keySer;
            this.previousValueSerializer = valueSer;
        }

        @Override
        public int getCurrentVersion() {
            return 3;
        }

        @Override
        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject(outStream, this.previousKeyType);
            InstantiationUtil.serializeObject(outStream, this.previousValueType);
            InstantiationUtil.serializeObject(outStream, this.previousKeySerializer);
            InstantiationUtil.serializeObject(outStream, this.previousValueSerializer);
        }

        @Override
        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.previousKeyType = (LogicalType)InstantiationUtil.deserializeObject(inStream, userCodeClassLoader);
                this.previousValueType = (LogicalType)InstantiationUtil.deserializeObject(inStream, userCodeClassLoader);
                this.previousKeySerializer = (TypeSerializer)InstantiationUtil.deserializeObject(inStream, userCodeClassLoader);
                this.previousValueSerializer = (TypeSerializer)InstantiationUtil.deserializeObject(inStream, userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public TypeSerializer<MapData> restoreSerializer() {
            return new MapDataSerializer(this.previousKeyType, this.previousValueType, this.previousKeySerializer, this.previousValueSerializer);
        }

        @Override
        public TypeSerializerSchemaCompatibility<MapData> resolveSchemaCompatibility(TypeSerializer<MapData> newSerializer) {
            if (!(newSerializer instanceof MapDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            MapDataSerializer newBaseMapSerializer = (MapDataSerializer)newSerializer;
            if (!(this.previousKeyType.equals(newBaseMapSerializer.keyType) && this.previousValueType.equals(newBaseMapSerializer.valueType) && this.previousKeySerializer.equals(newBaseMapSerializer.keySerializer) && this.previousValueSerializer.equals(newBaseMapSerializer.valueSerializer))) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

