/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationWithComponentId;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriverAdapterFactory;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMultipleComponentLeaderElectionService
implements MultipleComponentLeaderElectionService,
MultipleComponentLeaderElectionDriver.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMultipleComponentLeaderElectionService.class);
    private final Object lock = new Object();
    private final MultipleComponentLeaderElectionDriver multipleComponentLeaderElectionDriver;
    private final FatalErrorHandler fatalErrorHandler;
    @GuardedBy(value="lock")
    private final ExecutorService leadershipOperationExecutor;
    @GuardedBy(value="lock")
    private final Map<String, LeaderElectionEventHandler> leaderElectionEventHandlers;
    @GuardedBy(value="lock")
    private boolean running = true;
    @Nullable
    @GuardedBy(value="lock")
    private UUID currentLeaderSessionId = null;

    @VisibleForTesting
    DefaultMultipleComponentLeaderElectionService(FatalErrorHandler fatalErrorHandler, MultipleComponentLeaderElectionDriverFactory multipleComponentLeaderElectionDriverFactory, ExecutorService leadershipOperationExecutor) throws Exception {
        this.fatalErrorHandler = Preconditions.checkNotNull(fatalErrorHandler);
        this.leadershipOperationExecutor = Preconditions.checkNotNull(leadershipOperationExecutor);
        this.leaderElectionEventHandlers = new HashMap<String, LeaderElectionEventHandler>();
        this.multipleComponentLeaderElectionDriver = multipleComponentLeaderElectionDriverFactory.create(this);
    }

    public DefaultMultipleComponentLeaderElectionService(FatalErrorHandler fatalErrorHandler, MultipleComponentLeaderElectionDriverFactory multipleComponentLeaderElectionDriverFactory) throws Exception {
        this(fatalErrorHandler, multipleComponentLeaderElectionDriverFactory, Executors.newSingleThreadExecutor(new ExecutorThreadFactory("leadershipOperationExecutor")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            LOG.info("Closing {}.", (Object)this.getClass().getSimpleName());
            ExecutorUtils.gracefulShutdown(10L, TimeUnit.SECONDS, this.leadershipOperationExecutor);
            this.multipleComponentLeaderElectionDriver.close();
        }
    }

    @Override
    public LeaderElectionDriverFactory createDriverFactory(String componentId) {
        return new MultipleComponentLeaderElectionDriverAdapterFactory(componentId, this);
    }

    @Override
    public void publishLeaderInformation(String componentId, LeaderInformation leaderInformation) {
        try {
            this.multipleComponentLeaderElectionDriver.publishLeaderInformation(componentId, leaderInformation);
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)new FlinkException(String.format("Could not write leader information %s for leader %s.", leaderInformation, componentId), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLeaderElectionEventHandler(String componentId, LeaderElectionEventHandler leaderElectionEventHandler) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkArgument(!this.leaderElectionEventHandlers.containsKey(componentId), "Do not support duplicate LeaderElectionEventHandler registration under %s", componentId);
            this.leaderElectionEventHandlers.put(componentId, leaderElectionEventHandler);
            if (this.currentLeaderSessionId != null) {
                UUID leaderSessionId = this.currentLeaderSessionId;
                this.leadershipOperationExecutor.execute(() -> leaderElectionEventHandler.onGrantLeadership(leaderSessionId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLeaderElectionEventHandler(String componentId) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            LeaderElectionEventHandler unregisteredLeaderElectionEventHandler = this.leaderElectionEventHandlers.remove(componentId);
            if (unregisteredLeaderElectionEventHandler != null) {
                this.leadershipOperationExecutor.execute(unregisteredLeaderElectionEventHandler::onRevokeLeadership);
            } else {
                LOG.debug("Could not find leader election event handler for componentId {}. Ignoring the unregister call.", (Object)componentId);
            }
        }
        this.multipleComponentLeaderElectionDriver.deleteLeaderInformation(componentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLeadership(String componentId) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.running);
            return this.leaderElectionEventHandlers.containsKey(componentId) && this.multipleComponentLeaderElectionDriver.hasLeadership();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void isLeader() {
        UUID newLeaderSessionId = UUID.randomUUID();
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.currentLeaderSessionId = UUID.randomUUID();
            this.forEachLeaderElectionEventHandler(leaderElectionEventHandler -> leaderElectionEventHandler.onGrantLeadership(newLeaderSessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.currentLeaderSessionId = null;
            this.forEachLeaderElectionEventHandler(LeaderElectionEventHandler::onRevokeLeadership);
        }
    }

    @GuardedBy(value="lock")
    private void forEachLeaderElectionEventHandler(Consumer<? super LeaderElectionEventHandler> action) {
        for (LeaderElectionEventHandler leaderElectionEventHandler : this.leaderElectionEventHandlers.values()) {
            this.leadershipOperationExecutor.execute(() -> action.accept(leaderElectionEventHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLeaderInformationChange(String componentId, LeaderInformation leaderInformation) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            LeaderElectionEventHandler leaderElectionEventHandler = this.leaderElectionEventHandlers.get(componentId);
            if (leaderElectionEventHandler != null) {
                this.sendLeaderInformationChange(leaderElectionEventHandler, leaderInformation);
            }
        }
    }

    @GuardedBy(value="lock")
    private void sendLeaderInformationChange(LeaderElectionEventHandler leaderElectionEventHandler, LeaderInformation leaderInformation) {
        this.leadershipOperationExecutor.execute(() -> leaderElectionEventHandler.onLeaderInformationChange(leaderInformation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAllKnownLeaderInformation(Collection<LeaderInformationWithComponentId> leaderInformationWithComponentIds) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            Map<String, LeaderInformation> leaderInformationByName = leaderInformationWithComponentIds.stream().collect(Collectors.toMap(LeaderInformationWithComponentId::getComponentId, LeaderInformationWithComponentId::getLeaderInformation));
            for (Map.Entry<String, LeaderElectionEventHandler> leaderNameLeaderElectionEventHandlerPair : this.leaderElectionEventHandlers.entrySet()) {
                String leaderName = leaderNameLeaderElectionEventHandlerPair.getKey();
                if (leaderInformationByName.containsKey(leaderName)) {
                    this.sendLeaderInformationChange(leaderNameLeaderElectionEventHandlerPair.getValue(), leaderInformationByName.get(leaderName));
                    continue;
                }
                this.sendLeaderInformationChange(leaderNameLeaderElectionEventHandlerPair.getValue(), LeaderInformation.empty());
            }
        }
    }
}

