/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JvmUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JvmUtils.class);

    public static Collection<ThreadInfo> createThreadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        return Arrays.asList(threadMxBean.dumpAllThreads(true, true));
    }

    public static Optional<ThreadInfoSample> createThreadInfoSample(long threadId, int maxStackTraceDepth) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        return ThreadInfoSample.from(threadMxBean.getThreadInfo(threadId, maxStackTraceDepth));
    }

    public static Collection<ThreadInfoSample> createThreadInfoSample(Collection<Long> threadIds, int maxStackTraceDepth) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        long[] threadIdsArray = threadIds.stream().mapToLong(l -> l).toArray();
        ThreadInfo[] threadInfo = threadMxBean.getThreadInfo(threadIdsArray, maxStackTraceDepth);
        List<ThreadInfo> threadInfoNoNulls = IntStream.range(0, threadIdsArray.length).filter(i -> {
            if (threadInfo[i] == null) {
                LOG.debug("FlameGraphs: thread {} is not alive or does not exist.", (Object)threadIdsArray[i]);
                return false;
            }
            return true;
        }).mapToObj(i -> threadInfo[i]).collect(Collectors.toList());
        return ThreadInfoSample.from(threadInfoNoNulls);
    }

    private JvmUtils() {
    }
}

