/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.Preconditions;

public class LazyMemorySegmentPool
implements MemorySegmentPool,
Closeable {
    private static final long PER_REQUEST_MEMORY_SIZE = 0x1000000L;
    private final Object owner;
    private final MemoryManager memoryManager;
    private final ArrayList<MemorySegment> cachePages;
    private final int maxPages;
    private final int perRequestPages;
    private int pageUsage;

    public LazyMemorySegmentPool(Object owner, MemoryManager memoryManager, int maxPages) {
        this.owner = owner;
        this.memoryManager = memoryManager;
        this.cachePages = new ArrayList();
        this.maxPages = maxPages;
        this.pageUsage = 0;
        this.perRequestPages = Math.max(1, (int)(0x1000000L / (long)memoryManager.getPageSize()));
    }

    @Override
    public int pageSize() {
        return this.memoryManager.getPageSize();
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.pageUsage -= memory.size();
        if (this.pageUsage < 0) {
            throw new RuntimeException("Return too more memories.");
        }
        this.cachePages.addAll(memory);
    }

    public void returnPage(MemorySegment segment) {
        this.returnAll(Collections.singletonList(segment));
    }

    @Override
    public MemorySegment nextSegment() {
        int freePages = this.freePages();
        if (freePages == 0) {
            return null;
        }
        if (this.cachePages.isEmpty()) {
            int numPages = Math.min(freePages, this.perRequestPages);
            try {
                this.memoryManager.allocatePages(this.owner, this.cachePages, numPages);
            }
            catch (MemoryAllocationException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.pageUsage;
        return this.cachePages.remove(this.cachePages.size() - 1);
    }

    public List<MemorySegment> allocateSegments(int required) {
        int freePages = this.freePages();
        if (freePages < required) {
            return null;
        }
        ArrayList<MemorySegment> ret = new ArrayList<MemorySegment>(required);
        for (int i = 0; i < required; ++i) {
            MemorySegment segment;
            try {
                segment = this.nextSegment();
                Preconditions.checkNotNull(segment);
            }
            catch (Throwable t) {
                this.returnAll(ret);
                throw t;
            }
            ret.add(segment);
        }
        return ret;
    }

    @Override
    public int freePages() {
        return this.maxPages - this.pageUsage;
    }

    @Override
    public void close() {
        if (this.pageUsage != 0) {
            throw new RuntimeException("Should return all used memory before clean, page used: " + this.pageUsage);
        }
        this.cleanCache();
    }

    public void cleanCache() {
        this.memoryManager.release(this.cachePages);
    }
}

