/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshot;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshotPersistenceService;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSlotAllocationSnapshotPersistenceService
implements SlotAllocationSnapshotPersistenceService {
    private static final Logger LOG = LoggerFactory.getLogger(FileSlotAllocationSnapshotPersistenceService.class);
    private static final String SUFFIX = ".bin";
    private final File slotAllocationSnapshotDirectory;

    public FileSlotAllocationSnapshotPersistenceService(File slotAllocationSnapshotDirectory) {
        this.slotAllocationSnapshotDirectory = slotAllocationSnapshotDirectory;
        if (!slotAllocationSnapshotDirectory.exists() && !slotAllocationSnapshotDirectory.mkdirs()) {
            throw new IllegalStateException(String.format("Cannot create the slot allocation snapshot directory %s.", slotAllocationSnapshotDirectory));
        }
    }

    @Override
    public void persistAllocationSnapshot(SlotAllocationSnapshot slotAllocationSnapshot) throws IOException {
        File slotAllocationSnapshotFile = this.slotAllocationFile(slotAllocationSnapshot.getSlotID().getSlotNumber());
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(slotAllocationSnapshotFile));){
            oos.writeObject(slotAllocationSnapshot);
            LOG.debug("Successfully written allocation state metadata file {} for job {} and allocation {}.", new Object[]{slotAllocationSnapshotFile.toPath(), slotAllocationSnapshot.getJobId(), slotAllocationSnapshot.getAllocationId()});
        }
    }

    private File slotAllocationFile(int slotIndex) {
        return new File(this.slotAllocationSnapshotDirectory.getAbsolutePath(), FileSlotAllocationSnapshotPersistenceService.slotIndexToFilename(slotIndex));
    }

    private static String slotIndexToFilename(int slotIndex) {
        return slotIndex + SUFFIX;
    }

    private static int filenameToSlotIndex(String filename) {
        return Integer.parseInt(filename.substring(0, filename.length() - SUFFIX.length()));
    }

    @Override
    public void deleteAllocationSnapshot(int slotIndex) {
        File slotAllocationSnapshotFile = this.slotAllocationFile(slotIndex);
        try {
            FileUtils.deleteFileOrDirectory(slotAllocationSnapshotFile);
            LOG.debug("Successfully deleted allocation state metadata file {}.", (Object)slotAllocationSnapshotFile.toPath());
        }
        catch (IOException ioe) {
            LOG.warn("Cannot delete the local allocations state file {}.", (Object)slotAllocationSnapshotFile.toPath(), (Object)ioe);
        }
    }

    @Override
    public Collection<SlotAllocationSnapshot> loadAllocationSnapshots() {
        File[] slotAllocationFiles = this.slotAllocationSnapshotDirectory.listFiles();
        if (slotAllocationFiles == null) {
            LOG.debug("No allocation files to load.");
            return Collections.emptyList();
        }
        ArrayList<SlotAllocationSnapshot> slotAllocationSnapshots = new ArrayList<SlotAllocationSnapshot>(slotAllocationFiles.length);
        for (File allocationFile : slotAllocationFiles) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(allocationFile));){
                slotAllocationSnapshots.add((SlotAllocationSnapshot)ois.readObject());
            }
            catch (IOException | ClassNotFoundException e) {
                LOG.debug("Cannot read the local allocations state file {}. Deleting it now.", (Object)allocationFile.toPath(), (Object)e);
                this.deleteAllocationSnapshot(FileSlotAllocationSnapshotPersistenceService.filenameToSlotIndex(allocationFile.getName()));
            }
        }
        return slotAllocationSnapshots;
    }
}

