/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.exceptions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;

@PublicEvolving
public class PartitionAlreadyExistsException
extends Exception {
    private static final String MSG = "Partition %s of table %s in catalog %s already exists.";

    public PartitionAlreadyExistsException(String catalogName, ObjectPath tablePath, CatalogPartitionSpec partitionSpec) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName));
    }

    public PartitionAlreadyExistsException(String catalogName, ObjectPath tablePath, CatalogPartitionSpec partitionSpec, Throwable cause) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName), cause);
    }
}

