/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.Key;
import org.apache.flink.types.ResettableValue;

@Public
public class FloatValue
implements Comparable<FloatValue>,
ResettableValue<FloatValue>,
CopyableValue<FloatValue>,
Key<FloatValue> {
    private static final long serialVersionUID = 1L;
    private float value;

    public FloatValue() {
        this.value = 0.0f;
    }

    public FloatValue(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public void setValue(FloatValue value) {
        this.value = value.value;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeFloat(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(FloatValue o) {
        double other = o.value;
        return (double)this.value < other ? -1 : ((double)this.value > other ? 1 : 0);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FloatValue) {
            FloatValue other = (FloatValue)obj;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
        }
        return false;
    }

    @Override
    public int getBinaryLength() {
        return 4;
    }

    @Override
    public void copyTo(FloatValue target) {
        target.value = this.value;
    }

    @Override
    public FloatValue copy() {
        return new FloatValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }
}

