/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferConsumer
implements Closeable {
    private final Buffer buffer;
    private final CachedPositionMarker writerPosition;
    private int currentReaderPosition;

    public BufferConsumer(Buffer buffer, int size) {
        this(buffer, () -> -size, 0);
        Preconditions.checkState(this.isFinished(), "BufferConsumer with static size must be finished after construction!");
    }

    public BufferConsumer(Buffer buffer, BufferBuilder.PositionMarker currentWriterPosition, int currentReaderPosition) {
        this.buffer = Preconditions.checkNotNull(buffer);
        this.writerPosition = new CachedPositionMarker(Preconditions.checkNotNull(currentWriterPosition));
        Preconditions.checkArgument(currentReaderPosition <= this.writerPosition.getCached(), "Reader position larger than writer position");
        this.currentReaderPosition = currentReaderPosition;
    }

    public boolean isFinished() {
        return this.writerPosition.isFinished();
    }

    public Buffer build() {
        this.writerPosition.update();
        int cachedWriterPosition = this.writerPosition.getCached();
        Buffer slice = this.buffer.readOnlySlice(this.currentReaderPosition, cachedWriterPosition - this.currentReaderPosition);
        this.currentReaderPosition = cachedWriterPosition;
        return slice.retainBuffer();
    }

    void skip(int bytesToSkip) {
        this.writerPosition.update();
        int cachedWriterPosition = this.writerPosition.getCached();
        int bytesReadable = cachedWriterPosition - this.currentReaderPosition;
        Preconditions.checkState(bytesToSkip <= bytesReadable, "bytes to skip beyond readable range");
        this.currentReaderPosition += bytesToSkip;
    }

    public BufferConsumer copy() {
        return new BufferConsumer(this.buffer.retainBuffer(), this.writerPosition.positionMarker, this.currentReaderPosition);
    }

    public BufferConsumer copyWithReaderPosition(int readerPosition) {
        return new BufferConsumer(this.buffer.retainBuffer(), this.writerPosition.positionMarker, readerPosition);
    }

    public boolean isBuffer() {
        return this.buffer.isBuffer();
    }

    public Buffer.DataType getDataType() {
        return this.buffer.getDataType();
    }

    @Override
    public void close() {
        if (!this.buffer.isRecycled()) {
            this.buffer.recycleBuffer();
        }
    }

    public boolean isRecycled() {
        return this.buffer.isRecycled();
    }

    public int getWrittenBytes() {
        return this.writerPosition.getCached();
    }

    int getCurrentReaderPosition() {
        return this.currentReaderPosition;
    }

    boolean isStartOfDataBuffer() {
        return this.buffer.getDataType() == Buffer.DataType.DATA_BUFFER && this.currentReaderPosition == 0;
    }

    int getBufferSize() {
        return this.buffer.getMaxCapacity();
    }

    public boolean isDataAvailable() {
        return this.currentReaderPosition < this.writerPosition.getLatest();
    }

    /*
     * Loose catch block
     */
    public String toDebugString(boolean includeHash) {
        Buffer buffer = null;
        try {
            try (BufferConsumer copiedBufferConsumer = this.copy();){
                buffer = copiedBufferConsumer.build();
                Preconditions.checkState(copiedBufferConsumer.isFinished());
                String string = buffer.toDebugString(includeHash);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (buffer != null) {
                buffer.recycleBuffer();
            }
        }
    }

    private static class CachedPositionMarker {
        private final BufferBuilder.PositionMarker positionMarker;
        private int cachedPosition;

        CachedPositionMarker(BufferBuilder.PositionMarker positionMarker) {
            this.positionMarker = Preconditions.checkNotNull(positionMarker);
            this.update();
        }

        public boolean isFinished() {
            return BufferBuilder.PositionMarker.isFinished(this.cachedPosition);
        }

        public int getCached() {
            return BufferBuilder.PositionMarker.getAbsolute(this.cachedPosition);
        }

        private int getLatest() {
            return BufferBuilder.PositionMarker.getAbsolute(this.positionMarker.get());
        }

        private void update() {
            this.cachedPosition = this.positionMarker.get();
        }
    }
}

