/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.InternalProcessApplyWindowContext;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class ReduceApplyProcessWindowFunction<K, W extends Window, T, R>
extends ProcessWindowFunction<T, R, K, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;
    private final ProcessWindowFunction<T, R, K, W> windowFunction;
    private transient InternalProcessApplyWindowContext<T, R, K, W> ctx;

    public ReduceApplyProcessWindowFunction(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> windowFunction) {
        this.windowFunction = windowFunction;
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void process(K k, ProcessWindowFunction.Context context, Iterable<T> input, Collector<R> out) throws Exception {
        Object curr = null;
        for (T val : input) {
            if (curr == null) {
                curr = val;
                continue;
            }
            curr = this.reduceFunction.reduce(curr, val);
        }
        this.ctx.window = context.window();
        this.ctx.context = context;
        this.windowFunction.process(k, this.ctx, Collections.singletonList(curr), out);
    }

    @Override
    public void clear(ProcessWindowFunction.Context context) throws Exception {
        this.ctx.window = context.window();
        this.ctx.context = context;
        this.windowFunction.clear(this.ctx);
    }

    @Override
    public void open(Configuration configuration) throws Exception {
        FunctionUtils.openFunction(this.windowFunction, configuration);
        this.ctx = new InternalProcessApplyWindowContext<T, R, K, W>(this.windowFunction);
    }

    @Override
    public void close() throws Exception {
        FunctionUtils.closeFunction(this.windowFunction);
    }

    @Override
    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        FunctionUtils.setFunctionRuntimeContext(this.windowFunction, t);
    }
}

