/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.annotation.Experimental;

@Experimental
public class SinkUtils
implements Serializable {
    public static void tryAcquire(int permits, int maxConcurrentRequests, Duration maxConcurrentRequestsTimeout, Semaphore semaphore) throws InterruptedException, TimeoutException {
        if (!semaphore.tryAcquire(permits, maxConcurrentRequestsTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException(String.format("Failed to acquire %d out of %d permits to send value in %s.", permits, maxConcurrentRequests, maxConcurrentRequestsTimeout));
        }
    }
}

