/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.logging;

import jakarta.inject.Singleton;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.logging.LoggingFeature;
import org.grails.forge.feature.logging.template.logbackGroovy;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class LogbackGroovy
implements LoggingFeature {
    @Override
    public String getName() {
        return "logbackGroovy";
    }

    @Override
    public String getTitle() {
        return "Logback Groovy config";
    }

    @Override
    public String getDescription() {
        return "Enables Logback configuration with Groovy as an alternative to XML.";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        OperatingSystem operatingSystem = generatorContext.getOperatingSystem();
        boolean jansi = false;
        if (operatingSystem != OperatingSystem.WINDOWS) {
            jansi = true;
        }
        String projectName = generatorContext.getProject().getName();
        String packageName = generatorContext.getProject().getPackageName();
        generatorContext.addTemplate("loggingConfig", new RockerTemplate("grails-app/conf/logback-config.groovy", logbackGroovy.template(projectName, packageName, jansi)));
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-logging").implementation());
        generatorContext.addDependency(Dependency.builder().groupId("io.github.virtualdogbert").artifactId("logback-groovy-config").version("1.12.4").implementation());
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }
}

