/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.validation;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.OneOfFeature;
import org.grails.forge.feature.validation.FeatureValidator;
import org.grails.forge.options.Options;

@Singleton
public class OneOfFeatureValidator
implements FeatureValidator {
    private void validate(Set<Feature> features) {
        Set oneOfFeatures = features.stream().filter(feature -> feature instanceof OneOfFeature).map(OneOfFeature.class::cast).map(OneOfFeature::getFeatureClass).collect(Collectors.toSet());
        for (Class featureClass : oneOfFeatures) {
            List matches = features.stream().filter(feature -> featureClass.isAssignableFrom(feature.getClass())).map(Feature::getName).collect(Collectors.toList());
            if (matches.size() <= 1) continue;
            throw new IllegalArgumentException(String.format("There can only be one of the following features selected: %s", matches));
        }
    }

    @Override
    public void validatePreProcessing(Options options, ApplicationType applicationType, Set<Feature> features) {
        this.validate(features);
    }

    @Override
    public void validatePostProcessing(Options options, ApplicationType applicationType, Set<Feature> features) {
        this.validate(features);
    }
}

