/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler.tags;

import grails.util.GrailsStringUtils;
import org.grails.gsp.compiler.tags.GroovySyntaxTag;
import org.grails.taglib.GrailsTagException;

public class GroovyDefTag
extends GroovySyntaxTag {
    public static final String TAG_NAME = "def";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_TYPE = "type";

    @Override
    public void doStartTag() {
        String expr = (String)this.attributes.get(ATTRIBUTE_VALUE);
        if (GrailsStringUtils.isBlank(expr)) {
            throw new GrailsTagException("Tag [def] missing required attribute [value]", this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        expr = this.calculateExpression(expr);
        String var = (String)this.attributes.get("var");
        if (GrailsStringUtils.isBlank(var)) {
            throw new GrailsTagException("Tag [def] missing required attribute [var]", this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        var = this.extractAttributeValue(var);
        String typeName = (String)this.attributes.get(ATTRIBUTE_TYPE);
        typeName = GrailsStringUtils.isBlank(typeName) ? TAG_NAME : this.extractAttributeValue(typeName);
        this.out.print(typeName + " ");
        this.out.print(var);
        this.out.print('=');
        if (typeName.equals(TAG_NAME) || typeName.equals("Object")) {
            this.out.println(expr);
        } else {
            this.out.println(typeName + ".cast(" + expr + ")");
        }
    }

    @Override
    public void doEndTag() {
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public boolean isKeepPrecedingWhiteSpace() {
        return true;
    }

    @Override
    public boolean isAllowPrecedingContent() {
        return true;
    }
}

