/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.auth;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.GuacamoleCredentialsException;
import org.apache.guacamole.net.auth.credentials.GuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.apache.guacamole.net.event.AuthenticationFailureEvent;
import org.apache.guacamole.net.event.AuthenticationSuccessEvent;
import org.apache.guacamole.rest.auth.AuthTokenGenerator;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.rest.auth.DecorationService;
import org.apache.guacamole.rest.auth.GuacamoleAuthenticationProcessException;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.apache.guacamole.rest.event.ListenerService;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationService.class);
    @Inject
    private List<AuthenticationProvider> authProviders;
    @Inject
    private TokenSessionMap tokenSessionMap;
    @Inject
    private AuthTokenGenerator authTokenGenerator;
    @Inject
    private DecorationService decorationService;
    @Inject
    private ListenerService listenerService;
    public static final String TOKEN_HEADER_NAME = "Guacamole-Token";
    public static final String TOKEN_PARAMETER_NAME = "token";

    private AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleAuthenticationProcessException {
        AuthenticationProvider failedAuthProvider = null;
        Throwable authFailure = null;
        for (AuthenticationProvider authProvider : this.authProviders) {
            try {
                AuthenticatedUser authenticatedUser = authProvider.authenticateUser(credentials);
                if (authenticatedUser == null) continue;
                return authenticatedUser;
            }
            catch (GuacamoleInsufficientCredentialsException e) {
                if (authFailure != null && !(authFailure instanceof GuacamoleInvalidCredentialsException)) continue;
                failedAuthProvider = authProvider;
                authFailure = e;
            }
            catch (GuacamoleCredentialsException e) {
                if (authFailure != null) continue;
                failedAuthProvider = authProvider;
                authFailure = e;
            }
            catch (Error | RuntimeException | GuacamoleException e) {
                throw new GuacamoleAuthenticationProcessException("User authentication was aborted.", authProvider, e);
            }
        }
        throw new GuacamoleAuthenticationProcessException("User authentication failed.", failedAuthProvider, authFailure);
    }

    private AuthenticatedUser updateAuthenticatedUser(AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleAuthenticationProcessException {
        AuthenticationProvider authProvider = authenticatedUser.getAuthenticationProvider();
        try {
            authenticatedUser = authProvider.updateAuthenticatedUser(authenticatedUser, credentials);
            if (authenticatedUser == null) {
                throw new GuacamoleSecurityException("User re-authentication failed.");
            }
            return authenticatedUser;
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            throw new GuacamoleAuthenticationProcessException("User re-authentication failed.", authProvider, e);
        }
    }

    private AuthenticatedUser getAuthenticatedUser(GuacamoleSession existingSession, Credentials credentials) throws GuacamoleAuthenticationProcessException {
        if (existingSession != null) {
            AuthenticatedUser updatedUser = this.updateAuthenticatedUser(existingSession.getAuthenticatedUser(), credentials);
            return updatedUser;
        }
        AuthenticatedUser authenticatedUser = this.authenticateUser(credentials);
        return authenticatedUser;
    }

    private List<DecoratedUserContext> getUserContexts(GuacamoleSession existingSession, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleAuthenticationProcessException {
        ArrayList<DecoratedUserContext> userContexts = new ArrayList<DecoratedUserContext>(this.authProviders.size());
        if (existingSession != null) {
            List oldUserContexts = existingSession.getUserContexts();
            for (DecoratedUserContext userContext : oldUserContexts) {
                UserContext updatedUserContext;
                UserContext oldUserContext = userContext.getUndecoratedUserContext();
                AuthenticationProvider authProvider = oldUserContext.getAuthenticationProvider();
                try {
                    updatedUserContext = authProvider.updateUserContext(oldUserContext, authenticatedUser, credentials);
                }
                catch (Error | RuntimeException | GuacamoleException e) {
                    throw new GuacamoleAuthenticationProcessException("User authentication aborted during UserContext update.", authProvider, e);
                }
                if (updatedUserContext != null) {
                    userContexts.add(this.decorationService.redecorate(userContext, updatedUserContext, authenticatedUser, credentials));
                    continue;
                }
                logger.debug("AuthenticationProvider \"{}\" retroactively destroyed its UserContext.", (Object)authProvider.getClass().getName());
            }
        } else {
            for (AuthenticationProvider authProvider : this.authProviders) {
                UserContext userContext;
                try {
                    userContext = authProvider.getUserContext(authenticatedUser);
                }
                catch (Error | RuntimeException | GuacamoleException e) {
                    throw new GuacamoleAuthenticationProcessException("User authentication aborted during initial UserContext creation.", authProvider, e);
                }
                if (userContext == null) continue;
                userContexts.add(this.decorationService.decorate(userContext, authenticatedUser, credentials));
            }
        }
        return userContexts;
    }

    public String authenticate(Credentials credentials, String token) throws GuacamoleException {
        String authToken;
        try {
            for (AuthenticationProvider authProvider : this.authProviders) {
                try {
                    credentials = authProvider.updateCredentials(credentials);
                }
                catch (Error | RuntimeException | GuacamoleException e) {
                    throw new GuacamoleAuthenticationProcessException("User authentication aborted during credential update/revision.", authProvider, e);
                }
            }
            Credentials updatedCredentials = credentials;
            this.listenerService.handleEvent(() -> updatedCredentials);
            GuacamoleSession existingSession = token != null ? this.tokenSessionMap.get(token) : null;
            AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(existingSession, updatedCredentials);
            List userContexts = this.getUserContexts(existingSession, authenticatedUser, updatedCredentials);
            if (existingSession != null) {
                authToken = token;
                existingSession.setAuthenticatedUser(authenticatedUser);
                existingSession.setUserContexts(userContexts);
            } else {
                authToken = this.authTokenGenerator.getToken();
                this.tokenSessionMap.put(authToken, new GuacamoleSession(this.listenerService, authenticatedUser, userContexts));
            }
            try {
                this.listenerService.handleEvent((Object)new AuthenticationSuccessEvent(authenticatedUser, existingSession != null));
            }
            catch (GuacamoleException e) {
                throw new GuacamoleAuthenticationProcessException("User authentication aborted by event listener.", null, (Throwable)e);
            }
        }
        catch (GuacamoleAuthenticationProcessException e) {
            this.listenerService.handleEvent((Object)new AuthenticationFailureEvent(credentials, e.getAuthenticationProvider(), e.getCause()));
            e.rethrowCause();
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.warn("An underlying internal error was not correctly rethrown by rethrowCause(): {}", (Object)cause.getMessage());
                logger.debug("Internal error not rethrown by rethrowCause().", cause);
            } else {
                logger.warn("An underlying internal error was not correctly rethrown by rethrowCause().");
            }
            throw e.getCauseAsGuacamoleException();
        }
        return authToken;
    }

    public GuacamoleSession getGuacamoleSession(String authToken) throws GuacamoleException {
        GuacamoleSession session = this.tokenSessionMap.get(authToken);
        if (session == null) {
            throw new GuacamoleUnauthorizedException("Permission Denied.");
        }
        return session;
    }

    public boolean destroyGuacamoleSession(String authToken) {
        GuacamoleSession session = this.tokenSessionMap.remove(authToken);
        if (session == null) {
            return false;
        }
        session.invalidate();
        return true;
    }

    public List<DecoratedUserContext> getUserContexts(String authToken) throws GuacamoleException {
        return this.getGuacamoleSession(authToken).getUserContexts();
    }

    public String getAuthenticationToken(ContainerRequest request) {
        String token = request.getHeaderString(TOKEN_HEADER_NAME);
        if (token != null && !token.isEmpty()) {
            return token;
        }
        token = (String)request.getUriInfo().getQueryParameters().getFirst((Object)TOKEN_PARAMETER_NAME);
        if (token != null && !token.isEmpty()) {
            return token;
        }
        return null;
    }
}

