/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.net.auth.ActivityLog;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.rest.history.APIActivityRecord;
import org.apache.guacamole.rest.history.ActivityLogResource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ActivityRecordResource {
    private final ActivityRecord record;
    private final APIActivityRecord externalRecord;

    public ActivityRecordResource(ActivityRecord record, APIActivityRecord externalRecord) {
        this.record = record;
        this.externalRecord = externalRecord;
    }

    @GET
    public APIActivityRecord getRecord() {
        return this.externalRecord;
    }

    @Path(value="logs/{name}")
    public ActivityLogResource getLog(@PathParam(value="name") String logName) throws GuacamoleException {
        ActivityLog log = (ActivityLog)this.record.getLogs().get(logName);
        if (log != null) {
            return new ActivityLogResource(log);
        }
        throw new GuacamoleResourceNotFoundException("No such log.");
    }
}

