/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.lang.reflect.InvocationTargetException;
import org.apache.guacamole.tunnel.TunnelLoader;
import org.apache.guacamole.tunnel.TunnelRequestService;
import org.apache.guacamole.tunnel.http.RestrictedGuacamoleHTTPTunnelServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelModule
extends ServletModule {
    private final Logger logger = LoggerFactory.getLogger(TunnelModule.class);
    private static final String[] WEBSOCKET_MODULES = new String[]{"org.apache.guacamole.tunnel.websocket.WebSocketTunnelModule", "org.apache.guacamole.tunnel.websocket.jetty8.WebSocketTunnelModule", "org.apache.guacamole.tunnel.websocket.jetty9.WebSocketTunnelModule", "org.apache.guacamole.tunnel.websocket.tomcat.WebSocketTunnelModule"};

    private boolean loadWebSocketModule(String classname) {
        try {
            Class<?> module = Class.forName(classname);
            TunnelLoader loader = (TunnelLoader)module.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (loader.isSupported()) {
                this.install((Module)loader);
                return true;
            }
        }
        catch (ClassNotFoundException module) {
        }
        catch (NoClassDefFoundError module) {
        }
        catch (NoSuchMethodException module) {
        }
        catch (InstantiationException e) {
            this.logger.debug("Error instantiating WebSocket module.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.debug("Error instantiating WebSocket module.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.debug("Error instantiating WebSocket module.", (Throwable)e);
        }
        return false;
    }

    protected void configureServlets() {
        this.bind(TunnelRequestService.class);
        this.serve("/tunnel", new String[0]).with(RestrictedGuacamoleHTTPTunnelServlet.class);
        for (String classname : WEBSOCKET_MODULES) {
            if (!this.loadWebSocketModule(classname)) continue;
            this.logger.debug("WebSocket module loaded: {}", (Object)classname);
            return;
        }
        this.logger.info("WebSocket support NOT present. Only HTTP will be used.");
    }
}

