/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.schema.row.ExpandableByteBuf;

abstract class VarTableFormat {
    public static final int FORMAT_CODE_MASK = 3;
    static final VarTableFormat SKIPPED = new SkipFormat();
    static final VarTableFormat TINY = new TinyFormat();
    static final VarTableFormat MEDIUM = new MediumFormat();
    static final VarTableFormat LARGE = new LargeFormat();
    private final int vartblEntrySize;
    private final int vartblSizeFieldSize;
    private final byte formatId;

    static VarTableFormat format(int payloadLen, int vartblSize) {
        if (payloadLen > 0) {
            if (payloadLen < 256 && vartblSize < 256) {
                return TINY;
            }
            if (payloadLen < 65536) {
                return MEDIUM;
            }
        }
        return LARGE;
    }

    public static VarTableFormat fromFlags(int chunkFlags) {
        int formatId = chunkFlags & 3;
        switch (formatId) {
            case 0: {
                return SKIPPED;
            }
            case 1: {
                return TINY;
            }
            case 2: {
                return MEDIUM;
            }
        }
        return LARGE;
    }

    VarTableFormat(int vartblSizeFieldSize, int vartblEntrySize, byte formatId) {
        this.vartblEntrySize = vartblEntrySize;
        this.vartblSizeFieldSize = vartblSizeFieldSize;
        this.formatId = formatId;
    }

    public byte formatId() {
        return this.formatId;
    }

    int vartableLength(int entries) {
        return entries <= 0 ? 0 : this.vartblSizeFieldSize + entries * this.vartblEntrySize;
    }

    int vartableEntryOffset(int idx) {
        return this.vartblSizeFieldSize + idx * this.vartblEntrySize;
    }

    abstract int readVarlenOffset(ByteBuffer var1, int var2, int var3);

    abstract int readVartableSize(ByteBuffer var1, int var2);

    public abstract int compactVarTable(ExpandableByteBuf var1, int var2, int var3);

    private static class LargeFormat
    extends VarTableFormat {
        private static byte FORMAT_ID = (byte)3;

        LargeFormat() {
            super(2, 4, FORMAT_ID);
        }

        @Override
        int readVarlenOffset(ByteBuffer chunk, int vartblOff, int entryIdx) {
            return chunk.getInt(vartblOff + this.vartableEntryOffset(entryIdx));
        }

        @Override
        int readVartableSize(ByteBuffer chunk, int vartblOff) {
            return Short.toUnsignedInt(chunk.getShort(vartblOff));
        }

        @Override
        public int compactVarTable(ExpandableByteBuf buf, int vartblOff, int entries) {
            buf.putShort(vartblOff, (short)entries);
            return 0;
        }
    }

    private static class MediumFormat
    extends VarTableFormat {
        private static final byte FORMAT_ID = 2;

        MediumFormat() {
            super(2, 2, (byte)2);
        }

        @Override
        int readVarlenOffset(ByteBuffer chunk, int vartblOff, int entryIdx) {
            return Short.toUnsignedInt(chunk.getShort(vartblOff + this.vartableEntryOffset(entryIdx)));
        }

        @Override
        int readVartableSize(ByteBuffer chunk, int vartblOff) {
            return Short.toUnsignedInt(chunk.getShort(vartblOff));
        }

        @Override
        public int compactVarTable(ExpandableByteBuf buf, int vartblOff, int entries) {
            buf.putShort(vartblOff, (short)entries);
            int dstOff = vartblOff + 2;
            int srcOff = vartblOff + 2;
            int i = 0;
            while (i < entries) {
                buf.putShort(dstOff, buf.getShort(srcOff));
                ++i;
                srcOff += 4;
                dstOff += 2;
            }
            buf.shift(srcOff, dstOff);
            return srcOff - dstOff;
        }
    }

    private static class TinyFormat
    extends VarTableFormat {
        private static final byte FORMAT_ID = 1;

        TinyFormat() {
            super(1, 1, (byte)1);
        }

        @Override
        int readVarlenOffset(ByteBuffer chunk, int vartblOff, int entryIdx) {
            return Byte.toUnsignedInt(chunk.get(vartblOff + this.vartableEntryOffset(entryIdx)));
        }

        @Override
        int readVartableSize(ByteBuffer chunk, int vartblOff) {
            return Byte.toUnsignedInt(chunk.get(vartblOff));
        }

        @Override
        public int compactVarTable(ExpandableByteBuf buf, int vartblOff, int entres) {
            assert (entres > 0 && entres < 65535);
            buf.put(vartblOff, (byte)entres);
            int dstOff = vartblOff + 1;
            int srcOff = vartblOff + 2;
            int i = 0;
            while (i < entres) {
                buf.put(dstOff, buf.get(srcOff));
                ++i;
                srcOff += 4;
                ++dstOff;
            }
            buf.shift(srcOff, dstOff);
            return srcOff - dstOff;
        }
    }

    private static class SkipFormat
    extends VarTableFormat {
        private static final byte FORMAT_ID = 0;

        SkipFormat() {
            super(0, 0, (byte)0);
        }

        @Override
        int readVarlenOffset(ByteBuffer chunk, int vartblOff, int entryIdx) {
            throw new IllegalStateException("Offset must be calculated by chunk when vartable is skipped");
        }

        @Override
        int readVartableSize(ByteBuffer chunk, int vartblOff) {
            return 0;
        }

        @Override
        public int compactVarTable(ExpandableByteBuf buf, int vartblOff, int entres) {
            throw new IllegalStateException("Skipped vartable must not be compacted");
        }
    }
}

