/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.connect;

import com.google.gson.Gson;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.config.StateConfigProvider;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.repl.config.RootConfig;
import org.apache.ignite.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElements;
import org.apache.ignite.rest.client.api.NodeConfigurationApi;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class ConnectCall
implements Call<ConnectCallInput, String> {
    private final Session session;
    private final StateConfigProvider stateConfigProvider;

    public ConnectCall(Session session, StateConfigProvider stateConfigProvider) {
        this.session = session;
        this.stateConfigProvider = stateConfigProvider;
    }

    @Override
    public CallOutput<String> execute(ConnectCallInput input) {
        try {
            String nodeUrl = input.getNodeUrl();
            String configuration = this.fetchNodeConfiguration(nodeUrl);
            this.session.setNodeName(this.fetchNodeName(nodeUrl));
            this.session.setNodeUrl(nodeUrl);
            this.stateConfigProvider.get().setProperty("ignite.last-connected-url", nodeUrl);
            this.session.setJdbcUrl(this.constructJdbcUrl(configuration, nodeUrl));
            this.session.setConnectedToNode(true);
            return DefaultCallOutput.success(MessageUiComponent.fromMessage("Connected to %s", UiElements.url(nodeUrl)).render());
        }
        catch (IllegalArgumentException | ApiException e) {
            this.session.setConnectedToNode(false);
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getNodeUrl()));
        }
    }

    private String fetchNodeName(String nodeUrl) throws ApiException {
        return new NodeManagementApi(Configuration.getDefaultApiClient().setBasePath(nodeUrl)).nodeState().getName();
    }

    private String fetchNodeConfiguration(String nodeUrl) throws ApiException {
        return new NodeConfigurationApi(Configuration.getDefaultApiClient().setBasePath(nodeUrl)).getNodeConfiguration();
    }

    private String constructJdbcUrl(String configuration, String nodeUrl) {
        try {
            String host = new URL(nodeUrl).getHost();
            RootConfig config = (RootConfig)new Gson().fromJson(configuration, RootConfig.class);
            return "jdbc:ignite:thin://" + host + ":" + config.clientConnector.port;
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }
}

