/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.metadata.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.NotNull;

public class FragmentMapping
implements Serializable {
    private List<ColocationGroup> colocationGroups;

    public FragmentMapping() {
    }

    private FragmentMapping(ColocationGroup colocationGroup) {
        this(ArrayUtils.asList((Object[])new ColocationGroup[]{colocationGroup}));
    }

    private FragmentMapping(List<ColocationGroup> colocationGroups) {
        this.colocationGroups = colocationGroups;
    }

    public static FragmentMapping create() {
        return new FragmentMapping(Collections.emptyList());
    }

    public static FragmentMapping create(String nodeId) {
        return new FragmentMapping(ColocationGroup.forNodes(Collections.singletonList(nodeId)));
    }

    public static FragmentMapping create(long sourceId) {
        return new FragmentMapping(ColocationGroup.forSourceId(sourceId));
    }

    public static FragmentMapping create(long sourceId, ColocationGroup group) {
        try {
            return new FragmentMapping(ColocationGroup.forSourceId(sourceId).colocate(group));
        }
        catch (ColocationMappingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean colocated() {
        return this.colocationGroups.isEmpty() || this.colocationGroups.size() == 1;
    }

    public FragmentMapping prune(IgniteRel rel) {
        if (this.colocationGroups.size() != 1) {
            return this;
        }
        return new FragmentMapping(((ColocationGroup)CollectionUtils.first(this.colocationGroups)).prune(rel));
    }

    public FragmentMapping combine(FragmentMapping other) {
        return new FragmentMapping(Commons.combine(this.colocationGroups, other.colocationGroups));
    }

    public FragmentMapping colocate(FragmentMapping other) throws ColocationMappingException {
        assert (this.colocated() && other.colocated());
        ColocationGroup first = (ColocationGroup)CollectionUtils.first(this.colocationGroups);
        ColocationGroup second = (ColocationGroup)CollectionUtils.first(other.colocationGroups);
        if (first == null && second == null) {
            return this;
        }
        if (first == null || second == null) {
            return new FragmentMapping((ColocationGroup)IgniteUtils.firstNotNull((Object[])new ColocationGroup[]{first, second}));
        }
        return new FragmentMapping(first.colocate(second));
    }

    public List<String> nodeIds() {
        return this.colocationGroups.stream().flatMap(g -> g.nodeIds().stream()).distinct().collect(Collectors.toList());
    }

    public FragmentMapping finalize(Supplier<List<String>> nodesSource) {
        if (this.colocationGroups.isEmpty()) {
            return this;
        }
        List<ColocationGroup> colocationGroups = this.colocationGroups;
        colocationGroups = Commons.transform(colocationGroups, ColocationGroup::finalaze);
        List<String> nodes = this.nodeIds();
        List<String> nodes0 = nodes.isEmpty() ? nodesSource.get() : nodes;
        colocationGroups = Commons.transform(colocationGroups, g -> g.mapToNodes(nodes0));
        return new FragmentMapping(colocationGroups);
    }

    @NotNull
    public ColocationGroup findGroup(long sourceId) {
        List groups = this.colocationGroups.stream().filter(c -> c.belongs(sourceId)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            throw new IllegalStateException("Failed to find group with given id. [sourceId=" + sourceId + "]");
        }
        if (groups.size() > 1) {
            throw new IllegalStateException("Multiple groups with the same id found. [sourceId=" + sourceId + "]");
        }
        return (ColocationGroup)CollectionUtils.first(groups);
    }
}

