/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.Endpoint;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

class EndpointsConfiguration {
    private static final String ENDPOINTS_PREFIX = "endpoints.";
    public static final String ENDPOINTS_ENABLED = "endpoints.enabled";
    public static final String ENDPOINTS_TAGS = "endpoints.tags";
    public static final String ENDPOINTS_PATH = "endpoints.path";
    public static final String ENDPOINTS_SERVERS = "endpoints.servers";
    public static final String ENDPOINTS_SECURITY_REQUIREMENTS = "endpoints.security-requirements";
    private final boolean enabled;
    private String path;
    private List<Tag> tags;
    private List<Server> servers;
    private List<SecurityRequirement> securityRequirements;
    private Map<String, Endpoint> endpoints;

    EndpointsConfiguration(VisitorContext context, Properties properties) {
        this.enabled = Boolean.parseBoolean(properties.getProperty(ENDPOINTS_ENABLED, Boolean.FALSE.toString()));
        if (!this.enabled) {
            return;
        }
        this.path = EndpointsConfiguration.parsePath(properties.getProperty(ENDPOINTS_PATH, ""));
        this.tags = EndpointsConfiguration.parseTags(properties.getProperty(ENDPOINTS_TAGS, "").split(","));
        this.servers = EndpointsConfiguration.parseServers(properties.getProperty(ENDPOINTS_SERVERS, ""), context);
        this.securityRequirements = EndpointsConfiguration.parseSecurityRequirements(properties.getProperty(ENDPOINTS_SECURITY_REQUIREMENTS, ""), context);
        this.endpoints = new LinkedHashMap<String, Endpoint>();
        HashMap map = new HashMap(properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put((String)key, (String)value)));
        map.entrySet().stream().filter(EndpointsConfiguration::validEntry).forEach(entry -> {
            int idx = ((String)entry.getKey()).lastIndexOf(46);
            if (idx <= 0 || idx == ((String)entry.getKey()).length() || entry.getValue() == null) {
                return;
            }
            String entryType = ((String)entry.getKey()).substring(idx + 1);
            String name = ((String)entry.getKey()).substring(ENDPOINTS_PREFIX.length(), idx);
            if ("security-requirements".equals(entryType)) {
                Endpoint endpoint = this.endpoints.computeIfAbsent(name, key -> new Endpoint());
                endpoint.setSecurityRequirements(EndpointsConfiguration.parseSecurityRequirements((String)entry.getValue(), context));
            } else if ("servers".equals(entryType)) {
                Endpoint endpoint = this.endpoints.computeIfAbsent(name, key -> new Endpoint());
                endpoint.setServers(EndpointsConfiguration.parseServers((String)entry.getValue(), context));
            } else if ("tags".equals(entryType)) {
                Endpoint endpoint = this.endpoints.computeIfAbsent(name, key -> new Endpoint());
                endpoint.setTags(EndpointsConfiguration.parseTags(((String)entry.getValue()).split(",")));
            } else if ("class".equals(entryType)) {
                Endpoint endpoint = this.endpoints.computeIfAbsent(name, key -> new Endpoint());
                endpoint.setClassElement(context.getClassElement((String)entry.getValue()));
            } else {
                return;
            }
        });
    }

    String getPath() {
        return this.path;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    List<Tag> getTags() {
        return this.tags;
    }

    Map<String, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    List<Server> getServers() {
        return this.servers;
    }

    List<SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    public String toString() {
        return "EndpointsConfiguration [enabled=" + this.enabled + ", path=" + this.path + ", tags=" + this.tags + ", endpoints=" + this.endpoints + "]";
    }

    private static List<Server> parseServers(String servers, VisitorContext context) {
        return EndpointsConfiguration.parseModel(servers, context, new TypeReference<List<Server>>(){});
    }

    private static List<SecurityRequirement> parseSecurityRequirements(String securityRequirements, VisitorContext context) {
        return EndpointsConfiguration.parseModel(securityRequirements, context, new TypeReference<List<SecurityRequirement>>(){});
    }

    private static <T> List<T> parseModel(String s, VisitorContext context, TypeReference<List<T>> typeReference) {
        if (s == null || s.isEmpty() || !s.startsWith("[") && !s.endsWith("]")) {
            return Collections.emptyList();
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (List)mapper.readValue(s, typeReference);
        }
        catch (JsonProcessingException e) {
            context.warn("Fail to parse " + typeReference.getType().toString() + ": " + s + " - " + e.getMessage(), null);
            return Collections.emptyList();
        }
    }

    private static boolean validEntry(Map.Entry<String, String> entry) {
        return entry.getKey().startsWith(ENDPOINTS_PREFIX) && !entry.getKey().equals(ENDPOINTS_ENABLED) && !entry.getKey().equals(ENDPOINTS_TAGS) && !entry.getKey().equals(ENDPOINTS_SERVERS) && !entry.getKey().equals(ENDPOINTS_SECURITY_REQUIREMENTS) && !entry.getKey().equals(ENDPOINTS_PATH);
    }

    private static List<Tag> parseTags(String ... stringTags) {
        if (stringTags.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(stringTags.length);
        for (String name : stringTags) {
            if (name == null || name.isEmpty()) continue;
            Tag tag = new Tag();
            tag.setName(name);
            tags.add(tag);
        }
        return tags;
    }

    private static String parsePath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }
}

