/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.lang.reflect.Constructor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeMessageTypes;
import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.JobExecutionContextImpl;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.message.ExecuteRequest;
import org.apache.ignite.internal.compute.message.ExecuteResponse;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.jetbrains.annotations.Nullable;

public class ComputeComponentImpl
implements ComputeComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ComputeComponentImpl.class);
    private static final long NETWORK_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private static final long THREAD_KEEP_ALIVE_SECONDS = 60L;
    private final Ignite ignite;
    private final MessagingService messagingService;
    private final ComputeConfiguration configuration;
    private ExecutorService jobExecutorService;
    private final ClassLoader jobClassLoader = Thread.currentThread().getContextClassLoader();
    private final ComputeMessagesFactory messagesFactory = new ComputeMessagesFactory();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final InFlightFutures inFlightFutures = new InFlightFutures();

    public ComputeComponentImpl(Ignite ignite, MessagingService messagingService, ComputeConfiguration configuration) {
        this.ignite = ignite;
        this.messagingService = messagingService;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> CompletableFuture<R> executeLocally(Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<R> completableFuture = this.doExecuteLocally(jobClass, args);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public <R> CompletableFuture<R> executeLocally(String jobClassName, Object ... args) {
        return CompletableFuture.completedFuture(null).thenCompose(ignore -> this.executeLocally(this.jobClass(jobClassName), args));
    }

    private <R> CompletableFuture<R> doExecuteLocally(Class<? extends ComputeJob<R>> jobClass, Object[] args) {
        assert (this.jobExecutorService != null) : "Not started yet!";
        CompletableFuture<R> future = this.startLocalExecution(jobClass, args);
        this.inFlightFutures.registerFuture(future);
        return future;
    }

    private <R> CompletableFuture<R> startLocalExecution(Class<? extends ComputeJob<R>> jobClass, Object[] args) {
        try {
            return CompletableFuture.supplyAsync(() -> this.executeJob(jobClass, args), this.jobExecutorService);
        }
        catch (RejectedExecutionException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private <R> R executeJob(Class<? extends ComputeJob<R>> jobClass, Object[] args) {
        ComputeJob<R> job = this.instantiateJob(jobClass);
        JobExecutionContextImpl context = new JobExecutionContextImpl(this.ignite);
        return (R)job.execute((JobExecutionContext)context, args);
    }

    private <R> ComputeJob<R> instantiateJob(Class<? extends ComputeJob<R>> jobClass) {
        if (!ComputeJob.class.isAssignableFrom(jobClass)) {
            throw new IgniteInternalException("'" + jobClass.getName() + "' does not implement ComputeJob interface");
        }
        try {
            Constructor<ComputeJob<R>> constructor = jobClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteInternalException("Cannot instantiate job", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> CompletableFuture<R> executeRemotely(ClusterNode remoteNode, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<R> completableFuture = this.doExecuteRemotely(remoteNode, jobClass, args);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public <R> CompletableFuture<R> executeRemotely(ClusterNode remoteNode, String jobClassName, Object ... args) {
        return CompletableFuture.completedFuture(null).thenCompose(ignored -> this.executeRemotely(remoteNode, this.jobClass(jobClassName), args));
    }

    private <R> CompletableFuture<R> doExecuteRemotely(ClusterNode remoteNode, Class<? extends ComputeJob<R>> jobClass, Object[] args) {
        ExecuteRequest executeRequest = this.messagesFactory.executeRequest().jobClassName(jobClass.getName()).args(args).build();
        CompletionStage future = this.messagingService.invoke(remoteNode, (NetworkMessage)executeRequest, Long.MAX_VALUE).thenCompose(message -> this.resultFromExecuteResponse((ExecuteResponse)message));
        this.inFlightFutures.registerFuture((CompletableFuture)future);
        return future;
    }

    private <R> CompletableFuture<R> resultFromExecuteResponse(ExecuteResponse executeResponse) {
        if (executeResponse.throwable() != null) {
            return CompletableFuture.failedFuture(executeResponse.throwable());
        }
        return CompletableFuture.completedFuture(executeResponse.result());
    }

    public synchronized void start() {
        this.jobExecutorService = new ThreadPoolExecutor((int)((Integer)this.configuration.threadPoolSize().value()), (int)((Integer)this.configuration.threadPoolSize().value()), 60L, TimeUnit.SECONDS, this.newExecutorServiceTaskQueue(), (ThreadFactory)new NamedThreadFactory(NamedThreadFactory.threadPrefix((String)this.ignite.name(), (String)"compute"), LOG));
        this.messagingService.addMessageHandler(ComputeMessageTypes.class, (message, senderAddr, correlationId) -> {
            assert (correlationId != null);
            if (message instanceof ExecuteRequest) {
                this.processExecuteRequest((ExecuteRequest)message, senderAddr, correlationId);
                return;
            }
            throw new IgniteInternalException("Unexpected message type " + message.getClass());
        });
    }

    BlockingQueue<Runnable> newExecutorServiceTaskQueue() {
        return new LinkedBlockingQueue<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExecuteRequest(ExecuteRequest executeRequest, NetworkAddress senderAddr, long correlationId) {
        if (!this.busyLock.enterBusy()) {
            this.sendExecuteResponse(null, (Throwable)new NodeStoppingException(), senderAddr, correlationId);
            return;
        }
        try {
            Class jobClass = this.jobClass(executeRequest.jobClassName());
            this.doExecuteLocally(jobClass, executeRequest.args()).handle((result, ex) -> this.sendExecuteResponse(result, (Throwable)ex, senderAddr, correlationId));
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Nullable
    private Object sendExecuteResponse(Object result, Throwable ex, NetworkAddress senderAddr, Long correlationId) {
        ExecuteResponse executeResponse = this.messagesFactory.executeResponse().result(result).throwable(ex).build();
        this.messagingService.respond(senderAddr, (NetworkMessage)executeResponse, correlationId.longValue());
        return null;
    }

    private <R, J extends ComputeJob<R>> Class<J> jobClass(String jobClassName) {
        try {
            return Class.forName(jobClassName, true, this.jobClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IgniteInternalException("Cannot load job class by name '" + jobClassName + "'", (Throwable)e);
        }
    }

    public void stop() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.jobExecutorService, (long)this.stopTimeoutMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.inFlightFutures.cancelInFlightFutures();
    }

    long stopTimeoutMillis() {
        return (Long)this.configuration.threadPoolStopTimeoutMillis().value();
    }
}

