/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.schemas.network.NodeFinderType;
import org.apache.ignite.configuration.schemas.network.NodeFinderView;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeFinder;
import org.apache.ignite.network.StaticNodeFinder;

public class NodeFinderFactory {
    public static NodeFinder createNodeFinder(NodeFinderView nodeFinderConfiguration) {
        NodeFinderType type;
        String typeString = nodeFinderConfiguration.type();
        try {
            type = NodeFinderType.valueOf((String)typeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to create NodeFinder " + typeString, e);
        }
        switch (type) {
            case STATIC: {
                return Arrays.stream(nodeFinderConfiguration.netClusterNodes()).map(NetworkAddress::from).collect(Collectors.collectingAndThen(Collectors.toUnmodifiableList(), StaticNodeFinder::new));
            }
        }
        throw new IllegalArgumentException("Unsupported NodeFinder type " + type);
    }
}

