/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.connect;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.EmptyCallInput;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElements;

@Singleton
public class DisconnectCall
implements Call<EmptyCallInput, String> {
    @Inject
    private final Session session;

    public DisconnectCall(Session session) {
        this.session = session;
    }

    @Override
    public CallOutput<String> execute(EmptyCallInput input) {
        if (this.session.isConnectedToNode()) {
            String nodeUrl = this.session.nodeUrl();
            this.session.setNodeUrl(null);
            this.session.setNodeName(null);
            this.session.setConnectedToNode(false);
            return DefaultCallOutput.success(MessageUiComponent.fromMessage("Disconnected from %s", UiElements.url(nodeUrl)).render());
        }
        return DefaultCallOutput.empty();
    }
}

