/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.internal.manager.Event;
import org.apache.ignite.internal.manager.EventListener;
import org.apache.ignite.internal.manager.EventParameters;
import org.apache.ignite.internal.manager.ListenerRemovedException;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public abstract class Producer<T extends Event, P extends EventParameters> {
    private ConcurrentHashMap<T, List<EventListener<P>>> listeners = new ConcurrentHashMap();

    public void listen(T evt, EventListener<P> closure) {
        this.listeners.computeIfAbsent(evt, evtKey -> new CopyOnWriteArrayList()).add(closure);
    }

    public void removeListener(T evt, EventListener<P> closure) {
        this.removeListener(evt, closure, null);
    }

    public void removeListener(T evt, EventListener<P> closure, @Nullable IgniteInternalCheckedException cause) {
        this.removeListener(evt, closure, cause, true);
    }

    private void removeListener(T evt, EventListener<P> closure, @Nullable IgniteInternalCheckedException cause, boolean callOnRemove) {
        if (this.listeners.computeIfAbsent(evt, evtKey -> new CopyOnWriteArrayList()).remove(closure) && callOnRemove) {
            closure.remove(cause == null ? new ListenerRemovedException() : (cause.getCause() == null ? cause : cause.getCause()));
        }
    }

    protected CompletableFuture<?> fireEvent(T evt, P params, Throwable err) {
        List<EventListener<P>> eventListeners = this.listeners.get(evt);
        if (eventListeners == null) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (EventListener<P> closure : eventListeners) {
            CompletionStage future = closure.notify(params, err).thenAccept(b -> {
                if (b.booleanValue()) {
                    this.removeListener(evt, closure, null, false);
                }
            });
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    protected CompletableFuture<?> fireEvent(T evt, P params) {
        return this.fireEvent(evt, params, null);
    }
}

